minetest.register_node("sbz_resources:simple_charge_generator", {
    description = "Simple Charge Generator\n\nGenerates: 10 Global Power.\nRequires 0.2 Core Dust per Second to run.",
    tiles = {"simple_charge_generator.png"},
    groups = {matter=1},
    sunlight_propagates = true,
    walkable = true,
    on_rightclick = function(pos, node, player, pointed_thing)
        local player_name = player:get_player_name()
        minetest.show_formspec(player_name, "sbz_resources:simple_charge_generator_formspec",
            "formspec_version[7]" ..
            "size[8,9]" ..
            "style_type[list;spacing=.2;size=.8]" ..
            "list[nodemeta:" ..pos.x .."," ..pos.y .."," ..pos.z .. ";main;3.5,2;1,1;]" ..
            "list[current_player;main;0,5;8,4;]" ..
            "listring[]")
    end,
    on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        local inv = meta:get_inventory()
        inv:set_size("main", 1)
    end,

    on_place = function(itemstack, placer, pointed_thing)
        local result = minetest.item_place(itemstack, placer, pointed_thing)
        -- start side questline for advanced matter extractor here, provided it's not already done
        return result
    end,
})