-- Simple Extractor Node
minetest.register_node("sbz_resources:simple_matter_extractor", {
    description = "Simple Matter Extractor\n\nConsumes: 3 Global Power.\nMatter per Second: 0.2",
    tiles = {"simple_matter_extractor.png"},
    groups = {matter=1},
    sunlight_propagates = true,
    walkable = true,
    on_rightclick = function(pos, node, player, pointed_thing)
        local player_name = player:get_player_name()
        minetest.show_formspec(player_name, "sbz_resources:simple_matter_extractor_formspec",
            "formspec_version[7]" ..
            "size[8,9]" ..
            "style_type[list;spacing=.2;size=.8]" ..
            "list[nodemeta:" ..pos.x .."," ..pos.y .."," ..pos.z .. ";main;3.5,2;1,1;]" ..
            "list[current_player;main;0,5;8,4;]" ..
            "listring[]")

        
        minetest.sound_play("machine_open", {
            to_player = player_name,
            gain = 1.0,
        })
    end,
    on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        local inv = meta:get_inventory()
        inv:set_size("main", 1)


        minetest.sound_play("machine_build", {
            to_player = player_name,
            gain = 1.0,
        })
        
        power_remove(3)
    end,

    on_dig = function(pos, node, digger)

        power_add(3)

        minetest.node_dig(pos, node, digger)
    end,
})
minetest.register_abm({
    label = "Simple Matter Extractor Extract",
    nodenames = {"sbz_resources:simple_matter_extractor"},
    interval = 5,
    chance = 1, 
    action = function(pos, node, active_object_count, active_object_count_wider)
        -- check for power
        if power_off() then 
            minetest.add_particlespawner({
                amount = 10,
                time = 1,
                minpos = {x = pos.x - 0.5, y = pos.y - 0.5, z = pos.z - 0.5},
                maxpos = {x = pos.x + 0.5, y = pos.y + 0.5, z = pos.z + 0.5},
                minvel = {x = -0.5, y = -0.5, z = -0.5},
                maxvel = {x = 0.5, y = 0.5, z = 0.5},
                minacc = {x = 0, y = 0, z = 0},
                maxacc = {x = 0, y = 0, z = 0},
                minexptime = 5,
                maxexptime = 10,
                minsize = 0.5,
                maxsize = 1.0,
                collisiondetection = false,
                vertical = false,
                texture = "error_particle.png",
                glow = 10
            })

            return 
        end

        local node = minetest.get_node(pos)
        local meta = minetest.get_meta(pos)
        local inv = meta:get_inventory()
        
        local itemstack = ItemStack("sbz_resources:matter_dust")
        itemstack:set_count(1)

        if inv:room_for_item("main", itemstack) then
            inv:add_item("main", itemstack)

            minetest.add_particlespawner({
                amount = 10,
                time = 1,
                minpos = {x = pos.x - 0.5, y = pos.y - 0.5, z = pos.z - 0.5},
                maxpos = {x = pos.x + 0.5, y = pos.y + 0.5, z = pos.z + 0.5},
                minvel = {x = -2, y = -2, z = -2},
                maxvel = {x = 2, y = 2, z = 2},
                minacc = {x = 0, y = 0, z = 0},
                maxacc = {x = 0, y = 0, z = 0},
                minexptime = 5,
                maxexptime = 10,
                minsize = 0.5,
                maxsize = 1.0,
                collisiondetection = false,
                vertical = false,
                texture = "matter_dust.png",
                glow = 10
            })
        end
    end,
})
minetest.register_craft({
    output = "sbz_resources:simple_matter_extractor",
    recipe = {
        {"sbz_resources:core_dust", "sbz_resources:matter_blob", "sbz_resources:core_dust"},
        {"sbz_resources:matter_blob", "sbz_resources:matter_annihilator", "sbz_resources:matter_blob"},
        {"sbz_resources:core_dust", "sbz_resources:matter_blob", "sbz_resources:core_dust"}
    }
})

-- Advanced Extractor Node
minetest.register_node("sbz_resources:advanced_matter_extractor", {
    description = "Advanced Matter Extractor\n\nConsumes: 5 Global Power.\nMatter per Second: 0.6\nHas a 1/50 Chance to Extract 1x 'Core Dust'.",
    tiles = {"advanced_matter_extractor.png"},
    groups = {matter=1},
    sunlight_propagates = true,
    walkable = true,
    on_rightclick = function(pos, node, player, pointed_thing)
        local player_name = player:get_player_name()
        minetest.show_formspec(player_name, "sbz_resources:advanced_matter_extractor_formspec",
            "formspec_version[7]" ..
            "size[8,9]" ..
            "style_type[list;spacing=.2;size=.8]" ..
            "list[nodemeta:" ..pos.x .."," ..pos.y .."," ..pos.z .. ";main;2.5,2;3,1;]" ..
            "list[current_player;main;0,5;8,4;]" ..
            "listring[]")
        
        
        minetest.sound_play("machine_open", {
            to_player = player_name,
            gain = 1.0,
        })
    end,
    on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        local inv = meta:get_inventory()
        inv:set_size("main", 3)

        minetest.sound_play("machine_build", {
            to_player = player_name,
            gain = 1.0,
        })
        power_remove(5)
    end,

    on_dig = function(pos, node, digger)

        power_add(5)

        minetest.node_dig(pos, node, digger)
    end,
})
minetest.register_abm({
    label = "Advanced Matter Extractor Extract",
    nodenames = {"sbz_resources:advanced_matter_extractor"},
    interval = 5,
    chance = 1, 
    action = function(pos, node, active_object_count, active_object_count_wider)
        -- check for power
        if power_off() then 
            minetest.add_particlespawner({
                amount = 10,
                time = 1,
                minpos = {x = pos.x - 0.5, y = pos.y - 0.5, z = pos.z - 0.5},
                maxpos = {x = pos.x + 0.5, y = pos.y + 0.5, z = pos.z + 0.5},
                minvel = {x = -0.5, y = -0.5, z = -0.5},
                maxvel = {x = 0.5, y = 0.5, z = 0.5},
                minacc = {x = 0, y = 0, z = 0},
                maxacc = {x = 0, y = 0, z = 0},
                minexptime = 5,
                maxexptime = 10,
                minsize = 0.5,
                maxsize = 1.0,
                collisiondetection = false,
                vertical = false,
                texture = "error_particle.png",
                glow = 10
            })

            return 
        end

        local node = minetest.get_node(pos)
        local meta = minetest.get_meta(pos)
        local inv = meta:get_inventory()
        
        local itemstack
        if math.random(50) == 1 then
            -- 1/50 chance to create core_dust
            itemstack = ItemStack("sbz_resources:core_dust")
            itemstack:set_count(1)
        else
            -- 49/50 chance to create matter_dust
            itemstack = ItemStack("sbz_resources:matter_dust")
            itemstack:set_count(3)
        end
        

        if inv:room_for_item("main", itemstack) then
            inv:add_item("main", itemstack)

            minetest.add_particlespawner({
                amount = 10,
                time = 1,
                minpos = {x = pos.x - 0.5, y = pos.y - 0.5, z = pos.z - 0.5},
                maxpos = {x = pos.x + 0.5, y = pos.y + 0.5, z = pos.z + 0.5},
                minvel = {x = -2, y = -2, z = -2},
                maxvel = {x = 2, y = 2, z = 2},
                minacc = {x = 0, y = 0, z = 0},
                maxacc = {x = 0, y = 0, z = 0},
                minexptime = 5,
                maxexptime = 10,
                minsize = 0.5,
                maxsize = 1.0,
                collisiondetection = false,
                vertical = false,
                texture = "matter_dust.png",
                glow = 10
            })
        end
    end,
})
minetest.register_craft({
    output = "sbz_resources:advanced_matter_extractor",
    recipe = {
        {"sbz_resources:matter_annihilator", "sbz_resources:matter_blob", "sbz_resources:matter_annihilator"},
        {"sbz_resources:matter_blob", "sbz_resources:simple_matter_extractor", "sbz_resources:matter_blob"},
        {"sbz_resources:matter_annihilator", "sbz_resources:matter_blob", "sbz_resources:matter_annihilator"}
    }
})