---@meta _
-- DRAFT 1 DONE
-- luanti/doc/lua_api.md: 'core' namespace reference > Global callback registration functions

-- ------------------------------ InventoryInfo ----------------------------- --

--[[
WIPDOC
]]
---@alias core.InventoryInfo.actions
--- | "move"
--- | "put"
--- | "take"

--[[
WIPDOC
]]
---@class core.InventoryInfo.move
--[[
WIPDOC
]]
---@field from_list core.InventoryList
--[[
WIPDOC
]]
---@field to_list core.InventoryList
--[[
WIPDOC
]]
---@field from_index int
--[[
WIPDOC
]]
---@field to_index int
--[[
WIPDOC
]]
---@field count int


--[[
WIPDOC
]]
---@class core.InventoryInfo.put_or_take
--[[
WIPDOC
]]
---@field listname core.InventoryList
--[[
WIPDOC
]]
---@field index int
--[[
WIPDOC
]]
---@field stack core.ItemStack

--[[
WIPDOC
]]
---@alias core.InventoryInfo core.InventoryInfo.move | core.InventoryInfo.put_or_take

-- ---------------------------- core.* functions ---------------------------- --

--[[
WIPDOC
]]
---@alias core.fn.allow_player_inventory_action fun(player:core.PlayerRef, action:core.InventoryInfo.actions, inventory:core.InvRef, inventory_info:core.InventoryInfo):int

--[[
* `core.register_allow_player_inventory_action(function(player, action, inventory, inventory_info))`
    * Determines how much of a stack may be taken, put or moved to a
      player inventory.
    * Function arguments: see `core.register_on_player_inventory_action`
    * Return a numeric value to limit the amount of items to be taken, put or
      moved. A value of `-1` for `take` will make the source stack infinite.
]]
---@param f core.fn.allow_player_inventory_action
function core.register_allow_player_inventory_action(f) end

--[[
WIPDOC
]]
---@alias core.fn.on_player_inventory_action fun(player:core.PlayerRef, action:core.InventoryInfo.actions, inventory:core.InvRef, inventory_info:core.InventoryInfo)


--[[
WIPDOC
]]
---@param f core.fn.on_player_inventory_action
function core.register_on_player_inventory_action(f) end