---@meta _
-- DRAFT 1 DONE
-- luanti/doc/lua_api.md: Fractal Value Noise
-- luanti/doc/lua_api.md: Flag Specifier Format

-- ---------------------------- NoiseParams.flags --------------------------- --

--[[
WIPDOC
]]
---@class core.NoiseParams.flags.tablefmt
--[[
WIPDOC
]]
---@field defaults boolean
--[[
WIPDOC
]]
---@field nodefaults boolean
--[[
WIPDOC
]]
---@field eased boolean
--[[
WIPDOC
]]
---@field noeased boolean
--[[
WIPDOC
]]
---@field absvalue boolean
--[[
WIPDOC
]]
---@field noabsvalue boolean

--[[
WIPDOC
]]
---@alias core.NoiseParams.flags.stringfmt string

--[[
WIPDOC
]]
---@alias core.NoiseParams.flags
--- | core.NoiseParams.flags.tablefmt
--- | core.NoiseParams.flags.stringfmt

-- --------------------------- NoiseParams.__base --------------------------- --

---@class _.NoiseParams.__base
--[[
After the multiplication by `scale` this is added to the result and is the final
step in creating the noise value.
Can be positive or negative.
]]
---@field offset number
--[[
Once all octaves have been combined, the result is multiplied by this.
Can be positive or negative.
]]
---@field scale number
--[[
This is a whole number that determines the entire pattern of the noise
variation. Altering it enables different noise patterns to be created.
With other parameters equal, different seeds produce different noise patterns
and identical seeds produce identical noise patterns.

For this parameter you can randomly choose any whole number. Usually it is
preferable for this to be different from other seeds, but sometimes it is useful
to be able to create identical noise patterns.

In some noise APIs the world seed is added to the seed specified in noise
parameters. This is done to make the resulting noise pattern vary in different
worlds, and be 'world-specific'.
]]
---@field seed int
--[[
The number of simple noise generators that are combined.
A whole number, 1 or more.
Each additional octave adds finer detail to the noise but also increases the
noise calculation load.
3 is a typical minimum for a high quality, complex and natural-looking noise
variation. 1 octave has a slight 'gridlike' appearance.

Choose the number of octaves according to the `spread` and `lacunarity`, and the
size of the finest detail you require. For example:
if `spread` is 512 nodes, `lacunarity` is 2.0 and finest detail required is 16
nodes, octaves will be 6 because the 'wavelengths' of the octaves will be
512, 256, 128, 64, 32, 16 nodes.
Warning: If the 'wavelength' of any octave falls below 1 an error will occur.
]]
---@field octaves int
--[[
Each additional octave has an amplitude that is the amplitude of the previous
octave multiplied by `persistence`, to reduce the amplitude of finer details,
as is often helpful and natural to do so.
Since this controls the balance of fine detail to large-scale detail
`persistence` can be thought of as the 'roughness' of the noise.

A positive or negative non-zero number, often between 0.3 and 1.0.
A common medium value is 0.5, such that each octave has half the amplitude of
the previous octave.
This may need to be tuned when altering `lacunarity`; when doing so consider
that a common medium value is 1 / lacunarity.

Instead of `persistence`, the key `persist` may be used to the same effect.
]]
---@field persistence number?
--[[
WIPDOC
]]
---@field persist number?
--[[
Each additional octave has a 'wavelength' that is the 'wavelength' of the
previous octave multiplied by 1 / lacunarity, to create finer detail.
'lacunarity' is often 2.0 so 'wavelength' often halves per octave.

A positive number no smaller than 1.0.
Values below 2.0 create higher quality noise at the expense of requiring more
octaves to cover a particular range of 'wavelengths'.
]]
---@field lacunarity number?
--[[
Leave this field unset for no special handling.
Currently supported are `defaults`, `eased` and `absvalue`:
]]
---@field flags core.NoiseParams.flags?

-- ------------------------------- NoiseParams ------------------------------ --

--[[
### Format example

For 2D or 3D value noise or value noise maps:

```lua
np_terrain = {
    offset = 0,
    scale = 1,
    spread = {x = 500, y = 500, z = 500},
    seed = 571347,
    octaves = 5,
    persistence = 0.63,
    lacunarity = 2.0,
    flags = "defaults, absvalue",
}
```

For 2D noise the Z component of `spread` is still defined but is ignored.
A single noise parameter table can be used for 2D or 3D noise.
]]
---@class core.NoiseParams.3d : _.NoiseParams.__base
--[[
For octave1, this is roughly the change of input value needed for a very large
variation in the noise value generated by octave1. It is almost like a
'wavelength' for the wavy noise variation.
Each additional octave has a 'wavelength' that is smaller than the previous
octave, to create finer detail. `spread` will therefore roughly be the typical
size of the largest structures in the final noise variation.

`spread` is a vector with values for x, y, z to allow the noise variation to be
stretched or compressed in the desired axes.
Values are positive numbers.
]]
---@field spread ivector

--[[
WIPDOC
]]
---@alias core.NoiseParams.2d core.NoiseParams.3d

--[[
WIPDOC
]]
---@alias core.NoiseParams
--- | core.NoiseParams.2d
--- | core.NoiseParams.3d