# Skyblock: Zero
Start from absolutely nothing in a skyblock world. Time is your resource. Get lost in the ambiance. Space is your canvas.<br>

For ContentDB users: This package includes this exact information in its `README.md` file. So you can read it locally at your own leisure.

## Playing
There is an in-game Quest Book to get you started. Have fun!<br>
- **Please report bugs in the package threads or github issues, i will fix them ASAP.**
<br>
I have included a CHANGELOG.md with the download for those interested.

## Copyright and Licensing
"Third party mods" refer to mods or modpacks originally created outside of Skyblock: Zero included as git submodules or forks. Some of these third party mods did not credit all of the involved people in the work itself, preferring to point at the git history. This is not changed, following the authors' wishes.

Generally, source code of original Skyblock: Zero mods are licensed under GPL-3.0-only by various contributors. Source code of third party mods has changes under the same license as the original work to allow easy remixing with the rest of the Luanti community as it's the exact same license as the original work. Skyblock: Zero is an aggregate necessarily conveyed under GPL-3.0-only; the third party mods keep their original licenses within this work.

Images, sounds and 3D models collectively referred to as *assets* or *media* introduced for Skyblock: Zero are licensed under a Creative Commons license (defaulting to CC BY-SA 4.0) or the same license of the original work. The most restrictive media license is CC BY-SA 4.0 and CC BY-SA 3.0. Forked/Modified third party mods usually have some assets replaced or removed from the original mod hence those assets are detached completely from the original mod's licensing.

"Technical changes" refer to *strictly functional, non-transformative De Minimis changes* as opposed to transformative changes that would be *eligible* for copyright. Examples includes minor text reformatting, typo fixes, indentation changes, size optimizations, file format transcoding, near lossless transformations, and metadata stripping. These changes are not mentioned, implying that technical changes occured.

In each both original mods and forked third party mods, there is a `COPYRIGHT.md` file containing more detailed copyright information.

The following licenses are used within this work.
- [GPL-3.0](https://www.gnu.org/licenses/gpl-3.0.html). Full text copy should be provided within the work. For Skyblock: Zero, a copy is provided at `LICENSE.txt` in the repo root.
- [GPL-2.0](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html). Full text copy should be provided within the work. If not, a copy is available in `docs/`.
- [Apache 2.0](https://www.apache.org/licenses/LICENSE-2.0). Full text copy should be provided within the work. If not, a copy is available in `docs/`.
- [LGPL-3.0](https://www.gnu.org/licenses/lgpl-3.0.html). Full text copy should be provided within the work along with GPL-3.0. If not, a copy is available in `docs/`.
- [LGPL-2.1](https://www.gnu.org/licenses/old-licenses/lgpl-2.1.html). Full text copy should be provided within the work. If not, a copy is available in `docs/`.
- [MIT](https://opensource.org/license/mit). Full text copy should be provided within the work by the author, simply saying *MIT License* is insufficient. Because the full text is also a copyright notice including the authors' names, a fallback copy cannot be provided.
- [0BSD](https://opensource.org/license/0bsd)
- [Unlicense](https://unlicense.org/)
- [CC0 1.0](https://creativecommons.org/publicdomain/zero/1.0/)
- [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/)
- [CC BY 3.0](https://creativecommons.org/licenses/by/3.0/)
- [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/)
- [CC BY-SA 3.0](https://creativecommons.org/licenses/by-sa/3.0/)

### Images and Textures

`menu/background.png` Copyright (C) 2024 ChefZander. CC BY-SA 4.0.

`menu/icon.png` Copyright (C) 2024 ChefZander. CC BY-SA 4.0.

### Music

`menu/theme.ogg` main menu music is "Tragic ambient main menu" by Brandon Morris. CC0. <https://opengameart.org/content/tragic-ambient-main-menu>

### Third Party Mods used
| Mod name                   | Source                                                                          | Code License | Media License | Modified | Notes |
|----------------------------|---------------------------------------------------------------------------------|--------------|---------------|----------|-------|
| jumpdrive                  | <https://github.com/mt-mods/jumpdrive>                                          | GPL-3.0-or-later | CC BY-SA 4.0 | ✅ |
| travelnet                  | <https://github.com/mt-mods/travelnet>                                          | GPL-3.0-or-later | CC BY-SA 3.0, CC0 | ✅ |
| unifieddyes                | <https://github.com/mt-mods/unifieddyes>                                        | GPL-2.0-or-later | 🔴 Unspecified/Same as Code License | ✅ | Replaced all risky media
| player_monoids             | <https://github.com/minetest-mods/player_monoids>                               | Apache-2.0 | N/A | ✅ |
| replacer                   | <https://github.com/SwissalpS/replacer>                                         | LGPL-3.0-or-later | 🔴 Unspecified/Same as Code License | ✅ | Replaced all risky media
| sbz_pipeworks (pipeworks)  | <https://github.com/mt-mods/pipeworks>                                          | LGPL-3.0-only | CC BY-SA 4.0 | ✅ |
| signs_lib                  | <https://github.com/mt-mods/signs_lib>                                          | LGPL-3.0-only | CC BY-SA 4.0 | ✅ |
| smartshop                  | <https://github.com/fluxionary/luanti-smartshop>                                | LGPL-3.0-only | CC BY-SA 3.0 | ✅ |
| hbsprint                   | <https://github.com/minetest-mods/hbsprint/>                                    | LGPL-2.1-only | CC BY-SA 3.0, CC0 | ✅ |
| voxelmodel                 | <https://github.com/Noodlemire/voxelmodel>                                      | LGPL-2.1-or-later | 🔴 Unspecified/Same as Code License | ✅ | Removed all risky media
| areas                      | <https://github.com/minetest-mods/areas/>, <https://github.com/BlockySurvival/areas> | LGPL-2.1-or-later | 🔴 Unspecified/Same as Code License | ✅ | Replaced all risky media
| stairs                     | <https://github.com/luanti-org/minetest_game/tree/master/mods/stairs>           | LGPLv-2.1-or-later | CC BY-SA 3.0 | ✅ |
| screwdriver                | <https://github.com/luanti-org/minetest_game/tree/master/mods/screwdriver>      | LGPL-2.1-or-later | CC BY-SA 3.0 | ✅ |
| sbz_wrench                 | <https://github.com/mt-mods/wrench>                                             | LGPL-2.1-or-later | CC BY-SA 4.0 | ✅ |
| unified_inventory          | <https://github.com/minetest-mods/unified_inventory>                            | LGPL-2.0-or-later | 🔴 Mix of many licenses | ✅ | Removed or replaced all risky media
| creative                   | <https://github.com/luanti-org/minetest_game/tree/master/mods/creative>         | MIT | CC BY-SA 3.0 | ✅ |
| vizlib                     | <https://github.com/OgelGames/vizlib/>                                          | MIT | CC0 | ✅ |
| metatool                   | <https://github.com/S-S-X/metatool>                                             | MIT | Unspecified/Same as Code License | ✅ |
| drawers                    | <https://github.com/minetest-mods/drawers/>, <https://github.com/pandorabox-io/pandorabox_custom/blob/master/chat/drawers_fix.lua> | MIT | Unspecified/Same as Code License | ✅ |
| hudbars                    | <https://codeberg.org/Wuzzy/minetest_hudbars>                                   | MIT | CC BY-SA 3.0, MIT | ✅ |
| playereffects              | <https://codeberg.org/Wuzzy/minetest_playereffects>                             | MIT | Unspecified/Same as Code License | ✅ |
| areasprotector             | <https://cheapiesystems.com/git/areasprotector/>                                | The Unlicense | N/A | ✅ |
| libox                      | <https://github.com/TheEt1234/libox/>                                           | LGPL-3.0-only | N/A | ❌ |
| minetest-fmod (fmod)       | <https://github.com/fluxionary/luanti-fmod>                                     | LGPL-3.0-only | N/A | ❌ |
| minetest-futil (futil)     | <https://github.com/fluxionary/luanti-futil/>                                   | LGPL-3.0-only | N/A | ❌ |
| unified_inventory_plus     | <https://github.com/mt-mods/unified_inventory_plus>                             | LGPL-3.0-only | CC0 | ❌ |
| player_api                 | <https://github.com/minetest-game/player_api/>                                  | LGPL-2.1-or-later | CC BY-SA 3.0 | ❌ |
| controls                   | <https://github.com/mt-mods/controls>                                           | MIT | N/A | ❌ |
| extended_placement         | <https://github.com/gamefreq0/extended_placement/>                              | MIT | N/A | ❌ |
| fakelib                    | <https://github.com/OgelGames/fakelib>                                          | MIT | N/A | ❌ |
| modlib                     | <https://github.com/appgurueu/modlib>                                           | MIT | N/A | ❌ |
| sethome                    | <https://github.com/minetest-game/sethome/>                                     | MIT | N/A | ❌ |
| stubes                     | <https://github.com/TheEt1234/luanti-stubes/>                                   | MIT | Unspecified/Same as Code License | ❌ |
| visible_wielditem          | <https://github.com/appgurueu/visible_wielditem/>                               | MIT | N/A | ❌ |
| hotbar_switching           | <https://github.com/TheEt1234/hotbar_switching/>                                | 0BSD | N/A | ❌ |

- 🔴 means the mod features risky/improper licensing of a category of work. e.g. images licensed as GPL-3.0 make little sense is generally risky to use.
- If you find any copyright information errors/inaccuracies, please make an issue or a pull request correcting it.
- Table sorted by this logic:
  1. Modified work is prioritized.
  2. More restrictive source code licenses are prioritized.

Mods likely to be converted to git submodules:
- travelnet
- player_monoids
- replacer
- signs_lib
- smartshop
- hbsprint
- voxelmodel
- screwdriver
- vizlib

## Contributing

Please refer to [`CONTRIBUTING.md`](CONTRIBUTING.md). If unsure, you can always ask for help either in Github or in Discord :)


## Direction
- Make luacontrollers better
- Switch away from, or heavily modify signs_lib, without being backwards incompatible with signs from previous versions of sbz
    - Things like rendering text without it being on a sign is impossible i think? which is horrible
- Rely more on stubes than pipeworks
- better tree code
- better planets
