
# Questline: Decorator

An island with just machines will look very boring! Use the knowledge from the Decorator Questline to spice up your island! These quests are not required for progression, but playing can get boring on an empty, barren, dark island. So don't just ignore this questline, okay? :P

## Compressed Core Dust

### Text

As you keep expanding your space station, you might wonder: "What am I going to do with all this Core Dust?". The answer to that question is to...  
  
Compress it! Compressed Core Dust can be used as a building material.

### Meta

Requires: A bigger platform

## More Antimatter

### Text

You can also craft Antimatter Blobs. They give off extremely faint light and unlock some lighting nodes to light up your island.  
You can also make antimatter versions of some decorational blocks!  
  
Previously, they used to explode when next to regular matter, but with new updates they no longer do.  

### Meta

Requires: Antimatter

## Anti-Annihilator

### Text

Unfortunately, you again don't seem to be strong enough to destroy that node [antimatter nodes] once you place it, so let's craft something that can.

### Meta

Requires: More Antimatter

## Screwdriver

### Text

Screwdriver rotates nodes when you click on one with it.  
TIP: This acts similarly to the Minetest Game screwdriver.

### Meta

Requires: Antimatter, Introduction

## CNC Machines

### Text

Do you want shapes that aren't blocks, like stairs or slabs?  
Oh do I have the machine for you!  
  
With a CNC machine you can make all sorts of stairs and slabs....  
Craft one, put in the block of your choosing*, and boom!  
  
*The node needs to be compatible with the CNC machine, it usually will have a grey "You can make stairs with it!" text.  

### Meta

Requires: Emittrium Circuits

## Factory Flooring

### Text

This is a node to use as floor for your factory, to give it those classic vibes.

### Meta

Requires: A bigger platform

## Tiled Factory Flooring

### Text

A variation of Factory Flooring which adds even more tiling!

### Meta

Requires: A bigger platform, Factory Flooring

## Factory Ventilator

### Text

You might want a Ventilation system inside a factory, just saying.

### Meta

Requires: Factory Flooring, Crusher

## Reinforced Matter

### Text

Normal matter isn't sturdy enough? Try this.

### Meta

Requires: A bigger platform, Matter Plates

## Emitter Immitators

### Text

Emitter Immitators are decorational nodes providing light.  
  
TIP: Emitter Immitators spawn a lot of particles when punched, try it!

### Meta

Requires: A bigger platform, More Antimatter

## Photon Lamps

### Text

Are Emitter Immitators too dim for you? Introducing: Photon Lamps!  
  
With this revolutionary technology you can light up your world the same way as with Emitter Immitators just brighter!  
  
To craft: A matter blob in the center, four matter plates in the corners and then just fill the rest of the spaces with regular Emitter Immitators.  
Boom! You're done! Now you've got yourself a Photon Lamp! No more sitting in darkness! Yay!

### Meta

Requires: Emitter Immitators, Matter Plates

## Phosphor

### Text

On the other hand, you can craft an Emittrium Circuit with an Emitter Imitator to make Phosphor, a very weak light source which however is turned on and off using power. This may be useful as an indicator of whether machines are working... or for discos.

### Meta

Requires: Emitter Immitators, Emittrium Circuits

## Signs

### Text

Do you want to write something that's visible in the world? You should consider crafting a sign.

### Meta

Requires: Antimatter

## Powered Lights

### Text

Do you want to light up an area, cheaply? Powered lamps are the way to do it, if you find something cheaper its a bug.  
Or do you want to light up a huge area, the Super Powered Lamp is for you, it fills up a 13x13x13 cube with invisible lights for somewhat low power consumption!

### Meta

Requires: Switching Station, More Antimatter, Emittrium Glass

## Coloring Tool

### Text

For coloring nodes.  
It requires 1 colorium per each node you are coloring.  
  
You extract colorium dust from colorium leaves, then you put it in the furnace.  
With that colorium, you make your tool.  

### Meta

Requires: Colorium Trees

## Bricks

### Text

More fancy traditional bricks to build with.  

### Meta

Requires: Clay

## Mystery Terrarium

### Text

I wonder what's in there...

### Meta

Requires: Growing Plants, Planet Ores

## Large Server Rack

### Text

A decor node that looks like a server rack, with rainbow LEDs.

### Meta

Requires: Engraver, Knowledge Stations, Ele Fabs

## Ground Line

### Text

A line on the ground. Not fully 2D. Can be colored.

### Meta

Requires: Colorium Trees

## Power Ground Line

### Text

Line on the ground, just like Ground Line. Animated, conducts power like a cable.

### Meta

Requires: Colorium Trees, Power Cables

## Antiblocks

### Text

Antiblock: Fully transparent node, which hides the faces of nodes behind them, allowing you to see through walls.
Airlike Antiblock: The same properties as the regular Antiblock, but you can walk through it.

### Meta

Requires: Colorium Trees, Antimatter