
# Questline: Emittrium Reactor

Emittrium reactors are another way of generating energy. They are a 3x3x3 cube made of reactor shells (or reactor glass), with a reactor core in the center. Some of the shells must be replaced with a reactor power port, a reactor coolant port, a reactor emittrium port, and a reactor infoscreen. It consumes emittrium and water.
If it doesn't have enough coolant (water), it heats up, and bad things happen if it heats up too much.

## Reactor Shells

### Text

Reactor Shells are needed for crafting the emittrium reactor parts and for construction of the emittrium reactor.  
You can also use them as a nice decorative block that won't explode to meteorites.

### Meta

Requires: Obtain Emittrium

## Reactor Glass

### Text

Reactor Glass is needed in crafting recipes and can optionally be used as a replacement for the reactor shell in the construction of the emittrium reactor.  
You can also use it as a nice decorative block that won't explode to meteorites.

### Meta

Requires: Emittrium Glass, Reactor Shells

## Reactor Infoscreens

### Text

A Reactor Infoscreen is needed in the construction of the emittrium reactor and is required to turn on the reactor.

### Meta

Requires: Reactor Glass

## Reactor Power Ports

### Text

A Reactor Power Port is needed in the construction of the emittrium reactor. It delivers the energy generated by the reactor core.

### Meta

Requires: Reactor Shells

## Reactor Coolant Ports

### Text

A Reactor Coolant Port is needed in the construction of the emittrium reactor. It needs 1 water bucket per second (delivered via pipes) to sustain reactor heat.

### Meta

Requires: Fluid Storage Tanks

## Reactor Emittrium Input

### Text

A Reactor Emittrium Input is needed in the construction of the emittrium reactor. It needs 16 emittrium per minute to fuel the reactor.

### Meta

Requires: Reactor Shells, Tubes

## Reactor Core

### Text

A Reactor Core is needed in the construction of the emittrium reactor. It needs to be in the center.

### Meta

Requires: Neutronium, Reactor Shells

## Building the emittrium reactor and turning it on

### Text

Build a 3x3x3 cube of reactor shells or reactor glass. In the center, place the core, but in place of some of the shells, build the extra blocks mentioned earlier (Emittrium Input, Coolant Port, Power Port, etc.).  
  
Now, to actually turn the reactor on, click the Infoscreen and turn it on in the UI. If something is wrong with the reactor, it will tell you.  
  
If you have multiple reactors, try pressing the re-link button if you think the Infoscreen is displaying the wrong information.  
The finished reactor should look something like this (obviously, there are many more ways to build it than just this):  
\<img name=questbook_image_reactor.png\>  
In older releases, the emittrium reactor used to explode when it ran out of coolant, but this is now no longer the case.

### Meta

Requires: Reactor Shells, Reactor Infoscreens, Reactor Power Ports, Reactor Coolant Ports, Reactor Emittrium Input, Reactor Core