--TODO: Fix animations for the model

player_api.register_model("sneaking_player.obj", {
	animation_speed = 30,
	textures = {"character.png"},
	animations = {
		stand     = {x = 0,   y = 79},
		lay       = {x = 162, y = 166, eye_height = 0.2, override_local = true,
			collisionbox = {-0.6, 0.0, -0.6, 0.6, 0.1, 0.6}},
		walk      = {x = 168, y = 187},
		mine      = {x = 189, y = 198},
		walk_mine = {x = 200, y = 219},
		sit       = {x = 81,  y = 160, eye_height = 0.6, override_local = true,
			collisionbox = {-0.3, 0.0, -0.3, 0.3, 0.8, 0.3}}
	},
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.5, 0.3},
	stepheight = 0.6,
	eye_height = 1.3,
})

core.register_globalstep(function()
    for _,player in ipairs(core.get_connected_players()) do
        if player:get_player_control().sneak then
            player_api.set_model(player,"sneaking_player.obj")
            player:set_properties({
                visual_size = {x=1,y=0.85},
            })
        else
            player_api.set_model(player,"character.b3d")
            player:set_properties({
                visual_size = {x=1,y=1},
            })
        end
    end
end)
