minetest_oneblock = {}

local storage = core.get_mod_storage()

core.set_mapgen_setting("mg_name", "singlenode", true)

local function set_storage(key,value)
    storage:set_int(key, value)
end

local function get_storage(key)
    if storage:contains(key) then
        return storage:get_int(key)
    else
        return nil
    end
end

if not get_storage("dig_count") then
    set_storage("dig_count", 0)
end
if not get_storage("dig_phase") then
    set_storage("dig_phase", 1)
end

core.register_tool("minetest_oneblock:node_remover", {
    description = "Node remover\nUse this to remove nodes that you cannot mine",
    inventory_image = "minetest_oneblock_node_remover.png",
    on_use = function(itemstack,player,pointed_thing)
        if pointed_thing then
            core.remove_node({x=0,y=0,z=0})
        end
    end,
    groups = {not_in_creative_inventory = 1}
})

core.register_on_joinplayer(function(player)
    local inv = player:get_inventory()
    if not inv:contains_item("main", "minetest_oneblock:node_remover") and inv:room_for_item("main", "minetest_oneblock:node_remover") then
        inv:add_item("main","minetest_oneblock:node_remover")
    end
    core.chat_send_player(player:get_player_name(), ("Your dig count is %d | You are on phase %d"):format(get_storage("dig_count"),get_storage("dig_phase")))
end)

local phase_1_nodes = {
    --Multiple of the same to give better chance for different nodes
    ["default:dirt"]=true,
    ["default:dirt"]=true,
    ["default:dirt"]=true,
    ["default:dirt_with_grass"]=true,
    ["default:dirt_with_grass"]=true,
    ["default:stone_with_coal"]=true,
    ["default:tree"]=true,
    ["default:leaves"]=true,
    ["default:aspen_tree"]=true,
    ["default:aspen_leaves"]=true,
    ["default:bush_leaves"]=true,
    ["default:bush_stem"]=true,
    ["default:stone"]=true,
    ["default:stone_with_iron"]=true,
    ["default:sand"]=true,
    ["default:sand"]=true,
    ["default:gravel"]=true,
    ["default:gravel"]=true,
}

local phase_2_nodes = {
    ["default:dirt"]=true,
    ["default:planks"]=true,
    ["default:stone"]=true,
    ["default:stone"]=true,
    ["default:stone_with_coal"]=true,
    ["default:stone_with_iron"]=true,
    ["default:stone_with_gold"]=true,
    ["default:stone_with_mese"]=true,
}

local phase_3_nodes = {
    ["default:stone"]=true,
    ["default:stone"]=true,
    ["default:stone"]=true,
    ["default:stone_with_iron"]=true,
    ["default:stone_with_iron"]=true,
    ["default:stone_with_gold"]=true,
    ["default:stone_with_gold"]=true,
    ["default:stone_with_mese"]=true,
    ["default:stone_with_coal"]=true,
    ["default:stone_with_mese"]=true,
    ["default:stone_with_diamond"]=true,
    ["default:obsidian"]=true,
    ["default:mese"]=true,
}

local phase_4_nodes = {
    ["default:ice"]=true,
    ["default:ice"]=true,
    ["default:ice"]=true,
    ["default:snowblock"]=true,
    ["default:snowblock"]=true,
    ["default:stone_with_diamond"]=true,
    ["default:stone_with_diamond"]=true,
    ["default:stone_with_coal"]=true,
    ["default:obsidian"]=true,
    ["default:pine_tree"]=true,
    ["default:pine_leaves"]=true,
}

local phase_5_nodes = {
    ["default:jungle_tree"]=true,
    ["default:jungle_tree"]=true,
    ["default:jungle_leaves"]=true,
    ["default:jungle_leaves"]=true,
    ["default:stone"]=true,
    ["default:stone_with_iron"]=true,
    ["default:stone_with_gold"]=true,
    ["default:stone_with_mese"]=true,
    ["default:stone_with_diamond"]=true,
    ["default:stone_with_coal"]=true,
    ["default:dirt_with_rainforest_litter"]=true,
}

local phase_6_nodes = {
    ["default:coral_skeleton"]=true,
    ["default:coral_green"]=true,
    ["default:coral_brown"]=true,
    ["default:coral_pink"]=true,
    ["default:coral_orange"]=true,
    ["default:water_source"]=true,
    ["default:sand"]=true,
    ["default:sand"]=true,
    ["default:gravel"]=true,
}

local phase_7_nodes = {
    ["default:sand"]=true,
    ["default:sand"]=true,
    ["default:dry_shrub"]=true,
    ["default:cactus"]=true,
    ["default:mese"]=true,
}

local phase_8_nodes = {
    ["default:dirt"]=true,
    ["default:sand"]=true,
    ["default:gravel"]=true,
    ["default:dirt_with_grass"]=true,
    ["default:tree"]=true,
    ["default:mese"]=true,
}

local phase_9_nodes = {
    ["default:acacia_tree"]=true,
    ["default:acacia_leaves"]=true,
    ["default:dry_grass"]=true,
    ["default:dirt"]=true,
    ["default:dirt_with_dry_grass"]=true,
    ["default:acacia_tree"]=true,
    ["default:acacia_leaves"]=true,
    ["default:dry_grass"]=true,
    ["default:dirt"]=true,
    ["default:dirt_with_dry_grass"]=true,
    ["default:stone_with_iron"]=true,
    ["default:stone_with_coal"]=true,
    ["default:stone_with_gold"]=true,
    ["default:stone_with_mese"]=true,
    ["default:stone_with_diamond"]=true,
}

local phase_10_nodes = {
    ["nether:rack_with_gold"]=true,
    ["nether:rack_with_gold"]=true,
    ["nether:rack_with_mese"]=true,
    ["nether:rack"]=true,
    ["nether:rack"]=true,
    ["nether:rack"]=true,
    ["nether:geode"]=true,
    ["nether:geodelite"]=true,
    ["nether:rack_deep"]=true,
    ["nether:sand"]=true,
    ["nether:sand"]=true,
    ["nether:glowstone"]=true,
    ["nether:glowstone_deep"]=true,
    ["nether:brick"]=true,
    ["default:obsidian"]=true,
    ["default:lava_source"]=true,
    ["default:lava_source"]=true,
}

local forbbiden_nodes = {
	["air"] = true,
	["ignore"] = true,
	["unknown"] = true,
}

local not_allowed = {
    ["fireflies:firefly"]=true,
    ["butterflies:butterfly_white"]=true,
    ["butterflies:butterfly_violet"]=true,
    ["butterflies:butterfly_red"]=true,
}

local phase_nodes = {{},{},{},{},{},{},{},{},{},{},{}}

core.register_on_mods_loaded(function()
    for name, def in pairs(core.registered_nodes) do
        if phase_1_nodes[name] then table.insert(phase_nodes[1], name) end
        if phase_2_nodes[name] then table.insert(phase_nodes[2], name) end
        if phase_3_nodes[name] then table.insert(phase_nodes[3], name) end
        if phase_4_nodes[name] then table.insert(phase_nodes[4], name) end
        if phase_5_nodes[name] then table.insert(phase_nodes[5], name) end
        if phase_6_nodes[name] then table.insert(phase_nodes[6], name) end
        if phase_7_nodes[name] then table.insert(phase_nodes[7], name) end
        if phase_8_nodes[name] then table.insert(phase_nodes[8], name) end
        if phase_9_nodes[name] then table.insert(phase_nodes[9], name) end
        if phase_10_nodes[name] then table.insert(phase_nodes[10], name) end
        if not forbbiden_nodes[name] and not not_allowed[name] and def.groups.not_in_creative_inventory ~= 1 and def.description ~= "" then table.insert(phase_nodes[11], name) end
    end 
end)

local function random_node_for_current_phase()
    local phase = get_storage("dig_phase") or 1
    local pool  = phase_nodes[phase] or {}
    if #pool == 0 then return "default:dirt" end
    return pool[math.random(#pool)]
end

core.register_globalstep(function(dtime)
    if core.get_node({x=0,y=0,z=0}).name == "air" then
        core.set_node({x=0,y=0,z=0}, {name = random_node_for_current_phase()})
    end
    if core.get_node({x=0,y=-1,z=0}).name == "air" then
        core.set_node({x=0,y=-1,z=0}, {name = "default:obsidian"})
    end
end)

core.register_on_newplayer(function(player)
    player:set_pos({x=0,y=1,z=0})
end)

core.register_on_dignode(function(pos, oldnode, digger)
    if not vector.equals(pos, {x=0, y=0, z=0}) then return end
    set_storage("dig_count",get_storage("dig_count")+1)
    if get_storage("dig_count") == 500 then
        set_storage("dig_phase",2)
        core.chat_send_all(("Phase 2 unlocked! Next phase at 1000"))
    elseif get_storage("dig_count") == 1000 then
        set_storage("dig_phase",3)
        core.chat_send_all(("Phase 3 unlocked! Next phase at 1500"))
    elseif get_storage("dig_count") == 1500 then
        set_storage("dig_phase",4)
        core.chat_send_all(("Phase 4 unlocked! Next phase at 2000"))
    elseif get_storage("dig_count") == 2000 then
        set_storage("dig_phase",5)
        core.chat_send_all(("Phase 5 unlocked! Next phase at 2500"))
    elseif get_storage("dig_count") == 2500 then
        set_storage("dig_phase",6)
        core.chat_send_all(("Phase 6 unlocked! Next phase at 3000"))
    elseif get_storage("dig_count") == 3000 then
        set_storage("dig_phase",7)
        core.chat_send_all(("Phase 7 unlocked! Next phase at 3500"))
    elseif get_storage("dig_count") == 3500 then
        set_storage("dig_phase",8)
        core.chat_send_all(("Phase 8 unlocked! Next phase at 4000"))
    elseif get_storage("dig_count") == 4000 then
        set_storage("dig_phase",9)
        core.chat_send_all(("Phase 9 unlocked! Next phase at 4500"))
    elseif get_storage("dig_count") == 4500 then
        set_storage("dig_phase",10)
        core.chat_send_all(("Phase 10 unlocked! Next phase at 5000"))
    elseif get_storage("dig_count") == 5000 then
        set_storage("dig_phase",11)
        core.chat_send_all(("Final phase unlocked! This phase has ALL registered blocks in this game (except forbbiden nodes)!"))
    end
    if core.get_modpath("mobs_animal") then
        if get_storage("dig_phase") == 1 then
            if math.random(1,50) == 1 then
                core.add_entity({x=0, y=1, z=0}, "mobs_animal:sheep_white")
            elseif math.random(1,50) == 2 then
                core.add_entity({x=0, y=1, z=0}, "mobs_animal:cow")
            elseif math.random(1,50) == 3 then
                core.add_entity({x=0, y=1, z=0}, "mobs_animal:pumba")
            end
        elseif get_storage("dig_phase") == 4 then
            if math.random(1,50) == 1 then
                core.add_entity({x=0, y=1, z=0}, "mobs_animal:penguin")
            end
        elseif get_storage("dig_phase") == 11 then
            if math.random(1,50) == 1 then
                core.add_entity({x=0, y=1, z=0}, "mobs_animal:penguin")
            elseif math.random(1,50) == 1 then
                core.add_entity({x=0, y=1, z=0}, "mobs_animal:sheep_white")
            elseif math.random(1,50) == 2 then
                core.add_entity({x=0, y=1, z=0}, "mobs_animal:cow")
            elseif math.random(1,50) == 3 then
                core.add_entity({x=0, y=1, z=0}, "mobs_animal:pumba")
            end
        end
    end
    if core.get_modpath("mobs_monster") then
        if get_storage("dig_phase") == 2 or get_storage("dig_phase") == 3 then
            if math.random(1,50) == 1 then
                core.add_entity({x=0, y=1, z=0}, "mobs_monster:stone_monster")
            end
        elseif get_storage("dig_phase") == 4 then
            if math.random(1,50) == 1 then
                core.add_entity({x=0, y=1, z=0}, "mobs_monster:oerkki")
            end
        elseif get_storage("dig_phase") == 5 or get_storage("dig_phase") == 7 or get_storage("dig_phase") == 9 then
            if math.random(1,50) == 1 then
                core.add_entity({x=0, y=1, z=0}, "mobs_monster:dirt_monster")
            end
        elseif get_storage("dig_phase") == 8 then
            if math.random(1,50) == 1 then
                core.add_entity({x=0, y=1, z=0}, "mobs_monster:sand_monster")
            end
        elseif get_storage("dig_phase") == 10 then
            if math.random(1,50) == 1 then
                core.add_entity({x=0, y=1, z=0}, "mobs_monster:mese_monster")
            end
        elseif get_storage("dig_phase") == 11 then
            if math.random(1,50) == 1 then
                core.add_entity({x=0, y=1, z=0}, "mobs_monster:mese_monster")
            elseif math.random(1,50) == 1 then
                core.add_entity({x=0, y=1, z=0}, "mobs_monster:sand_monster")
            elseif math.random(1,50) == 1 then
                core.add_entity({x=0, y=1, z=0}, "mobs_monster:dirt_monster")
            elseif math.random(1,50) == 1 then
                core.add_entity({x=0, y=1, z=0}, "mobs_monster:stone_monster")
            elseif math.random(1,50) == 1 then
                core.add_entity({x=0, y=1, z=0}, "mobs_monster:oerkki")
            end
        end
    end
end)

core.register_on_respawnplayer(function(player)
    player:set_pos({x=0,y=1,z=0})
end)
