--Get translator
local S = core.get_translator("shapetester")

--Shapeshift tool

core.register_tool("shapetester:shape_stone", {
    description = S("Shape-shift Stone"),
    inventory_image = "shapetester_shape_stone.png",
    sound = {breaks = "default_tool_breaks"},
    on_use = function(itemstack,user)
        local name = user:get_player_name()
        shapetester.show_shapeshift_menu(name)
        if not core.is_creative_enabled(name) then
            itemstack:add_wear_by_uses(10)
            return itemstack
        end
    end
})

--Recipe
core.register_craft({
    output = "shapetester:shape_stone",
    recipe = {
        {"default:diamondblock","default:stone","default:diamondblock"},
        {"default:stone","default:mese","default:stone"},
        {"default:diamondblock","default:stone","default:diamondblock"}
    }
})

--Technical shapeshift tool
local function sethand(player,handname)
    player:get_inventory():set_size("hand", 1)
    player:get_inventory():set_stack("hand", 1, handname)
    return true
end

core.register_tool("shapetester:shape_computer", {
    description = S("Shape-shift Computer"),
    inventory_image = "shapetester_shape_computer.png",
    on_use = function(itemstack,user)
        local name = user:get_player_name()
        shapetester.show_shapeshift_tech_menu(name)
    end
})

--formspec
function shapetester.shapeshift_tech_menu_form(player)
    local formspec = {
        "size[9.5,4.5]",
        "background[0,0;0,0;shapetester_menu.png;true]",
        "field[0.25,0.35;8,0.8;model;"..S("Model file name")..":;shapetester_cube.obj]",
        "field[8.25,0.35;1,0.8;gravity;"..S("Gravity")..":;1]",
        "field[8.25,1.85.35;1,0.8;speed;"..S("Speed")..":;1]",
        "field[8.25,3.35;1,0.8;jump;"..S("Jump")..":;1]",
        "field[0.25,1.35;8,0.8;image;"..S("Model image")..":;shapetester_cube.png]",
        "field[0.25,2.35;8,0.8;collision;"..S("Collision box")..":;-0.5 -0.5 -0.5 0.5 0.5 0.5]",
        "field[0.25,3.35;8,0.8;eyeheight;"..S("Eye height")..":;0.5]",
        "field[0.25,4.35;8,0.8;hand;"..S("Hand")..":;shapetester:cube_hand]",
        "button[8,4;1.6,0.8;transform;"..S("Transform!").."]",
    }

    return table.concat(formspec, "")
end

function shapetester.show_shapeshift_tech_menu(player)
    core.show_formspec(
        player,
        "shapetester:shapeshift_tech_menu",
        shapetester.shapeshift_tech_menu_form(player)
    )
end

core.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= "shapetester:shapeshift_tech_menu" then
        return false
    end
    if fields.transform then
        local coll = fields.collision:split(" ")
        player:set_properties({
            textures      = { fields.image },
            visual        = "mesh",
            mesh          = fields.model,
            collisionbox  = {tonumber(coll[1]),tonumber(coll[2]),tonumber(coll[3]),tonumber(coll[4]),tonumber(coll[5]),tonumber(coll[6])},
            eye_height    = tonumber(fields.eyeheight) or 0.5,
            visual_size   = { x = 1, y = 1 },
        })
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
    shapetester.sparks(player)
    player:set_physics_override({gravity = fields.gravity or 1,speed = fields.speed or 1,jump = fields.jump or 1})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
        core.close_formspec(player:get_player_name(), "shapetester:shapeshift_tech_menu")
        if fields.hand then
            sethand(player,fields.hand)
        end
    end
end)

--Recipe
core.register_craft({
    output = "shapetester:shape_computer",
    recipe = {
        {"default:mese","default:diamondblock","default:mese"},
        {"default:diamondblock","shapetester:shape_stone","default:diamondblock"},
        {"default:mese","default:diamondblock","default:mese"}
    }
})