--Get Translator
local S = core.get_translator("shapetester")

--Hands
--Local function to set hand
local function sethand(player,handname)
    player:get_inventory():set_size("hand", 1)
    player:get_inventory():set_stack("hand", 1, handname)
    return true
end

--Global reset hand function
function shapetester.reset_hand(player)
    player:get_inventory():set_size("hand", 0)
    return true
end

--Survival
if not core.is_creative_enabled("") then
    local survival_damage_weak = {
		full_punch_interval = 0.9,
		max_drop_level = 0,
		groupcaps = {
			crumbly = {times={[2]=3.00, [3]=0.70}, uses=0, maxlevel=1},
			snappy = {times={[3]=0.40}, uses=0, maxlevel=1},
			oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
		},
		damage_groups = {fleshy=0.5},
	}

    local survival_damage_normal = {
		full_punch_interval = 0.9,
		max_drop_level = 0,
		groupcaps = {
			crumbly = {times={[2]=3.00, [3]=0.70}, uses=0, maxlevel=1},
			snappy = {times={[3]=0.40}, uses=0, maxlevel=1},
			oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
		},
		damage_groups = {fleshy=1},
	}

    local survival_damage_medium = {
		full_punch_interval = 0.9,
		max_drop_level = 0,
		groupcaps = {
			crumbly = {times={[2]=3.00, [3]=0.70}, uses=0, maxlevel=1},
			snappy = {times={[3]=0.40}, uses=0, maxlevel=1},
			oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
		},
		damage_groups = {fleshy=3},
	}

    local survival_damage_strong = {
		full_punch_interval = 0.9,
		max_drop_level = 0,
		groupcaps = {
			crumbly = {times={[2]=3.00, [3]=0.70}, uses=0, maxlevel=1},
			snappy = {times={[3]=0.40}, uses=0, maxlevel=1},
			oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
		},
		damage_groups = {fleshy=5},
	}

    local survival_damage_op = {
		full_punch_interval = 0.9,
		max_drop_level = 0,
		groupcaps = {
			crumbly = {times={[2]=3.00, [3]=0.70}, uses=0, maxlevel=1},
			snappy = {times={[3]=0.40}, uses=0, maxlevel=1},
			oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
		},
		damage_groups = {fleshy=10},
	}

    hands.register_hand("shapetester:bunny_hand", {
        wield_image = "shapetester_hand_bunny.png",
        tool_capabilities = survival_damage_weak
    })

    hands.register_hand("shapetester:panda_hand", {
        wield_image = "shapetester_hand_panda.png",
        tool_capabilities = survival_damage_medium
    })

    hands.register_hand("shapetester:chicken_hand", {
        wield_image = "shapetester_hand_chicken.png",
        tool_capabilities = survival_damage_normal
    })

    hands.register_hand("shapetester:cow_hand", {
        wield_image = "shapetester_hand_cow.png",
        tool_capabilities = survival_damage_strong
    })

    hands.register_hand("shapetester:bee_hand", {
        wield_image = "shapetester_hand_bee.png",
        tool_capabilities = survival_damage_weak
    })

    hands.register_hand("shapetester:kitten_hand", {
        wield_image = "shapetester_hand_kitten.png",
        tool_capabilities = survival_damage_medium
    })

    hands.register_hand("shapetester:rat_hand", {
        wield_image = "shapetester_hand_rat.png",
        tool_capabilities = survival_damage_weak
    })

    hands.register_hand("shapetester:sheep_hand", {
        wield_image = "shapetester_hand_sheep.png",
        tool_capabilities = survival_damage_normal
    })

    hands.register_hand("shapetester:warthog_hand", {
        wield_image = "shapetester_hand_warthog.png",
        tool_capabilities = survival_damage_strong
    })

    hands.register_hand("shapetester:penguin_hand", {
        wield_image = "shapetester_hand_penguin.png",
        tool_capabilities = survival_damage_normal
    })

    hands.register_hand("shapetester:spider_hand", {
        wield_image = "shapetester_hand_spider.png",
        tool_capabilities = survival_damage_strong
    })

    hands.register_hand("shapetester:dungeon_master_hand", {
        wield_image = "shapetester_hand_dungeon_master.png",
        tool_capabilities = survival_damage_op
    })

    hands.register_hand("shapetester:mese_monster_hand", {
        wield_image = "shapetester_hand_mese_monster.png",
        tool_capabilities = survival_damage_strong
    })

    hands.register_hand("shapetester:oerkki_hand", {
        wield_image = "shapetester_hand_oerkki.png",
        tool_capabilities = survival_damage_strong
    })

    hands.register_hand("shapetester:sand_monster_hand", {
        wield_image = "shapetester_hand_sand_monster.png",
        tool_capabilities = survival_damage_medium
    })

    hands.register_hand("shapetester:stone_monster_hand", {
        wield_image = "shapetester_hand_stone_monster.png",
        tool_capabilities = survival_damage_medium
    })

    hands.register_hand("shapetester:dirt_monster_hand", {
        wield_image = "shapetester_hand_dirt_monster.png",
        tool_capabilities = survival_damage_medium
    })

    hands.register_hand("shapetester:tree_monster_hand", {
        wield_image = "shapetester_hand_tree_monster.png",
        tool_capabilities = survival_damage_strong
    })

    hands.register_hand("shapetester:lava_flan_hand", {
        wield_image = "shapetester_hand_lava_flan.png",
        tool_capabilities = survival_damage_strong
    })

    hands.register_hand("shapetester:land_guard_hand", {
        wield_image = "shapetester_hand_land_guard.png",
        tool_capabilities = survival_damage_strong
    })

    hands.register_hand("shapetester:fire_spirit_hand", {
        wield_image = "fire_basic_flame.png",
        tool_capabilities = survival_damage_medium
    })

    hands.register_hand("shapetester:horse_hand", {
        wield_image = "shapetester_hand_horse.png",
        tool_capabilities = survival_damage_strong
    })

    hands.register_hand("shapetester:cube_hand", {
        wield_image = "shapetester_hand_cube.png",
        tool_capabilities = survival_damage_op
    })
else
    --Creative
    local digtime = 42
	local caps = {times = {digtime, digtime, digtime}, uses = 0, maxlevel = 256}

    local creative_mining = {
		full_punch_interval = 0.5,
		max_drop_level = 3,
		groupcaps = {
			crumbly = caps,
			cracky  = caps,
			snappy  = caps,
			choppy  = caps,
			oddly_breakable_by_hand = caps,
			dig_immediate =
				{times = {[2] = digtime, [3] = 0}, uses = 0, maxlevel = 256},
		},
		damage_groups = {fleshy = 10},
	}

    hands.register_hand("shapetester:bunny_hand", {
        wield_image = "shapetester_hand_bunny.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:panda_hand", {
        wield_image = "shapetester_hand_panda.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:chicken_hand", {
        wield_image = "shapetester_hand_chicken.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:cow_hand", {
        wield_image = "shapetester_hand_cow.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:bee_hand", {
        wield_image = "shapetester_hand_bee.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:kitten_hand", {
        wield_image = "shapetester_hand_kitten.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:rat_hand", {
        wield_image = "shapetester_hand_rat.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:sheep_hand", {
        wield_image = "shapetester_hand_sheep.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:warthog_hand", {
        wield_image = "shapetester_hand_warthog.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:penguin_hand", {
        wield_image = "shapetester_hand_penguin.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:spider_hand", {
        wield_image = "shapetester_hand_spider.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:dungeon_master_hand", {
        wield_image = "shapetester_hand_dungeon_master.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:mese_monster_hand", {
        wield_image = "shapetester_hand_mese_monster.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:oerkki_hand", {
        wield_image = "shapetester_hand_oerkki.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:sand_monster_hand", {
        wield_image = "shapetester_hand_sand_monster.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:stone_monster_hand", {
        wield_image = "shapetester_hand_stone_monster.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:dirt_monster_hand", {
        wield_image = "shapetester_hand_dirt_monster.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:tree_monster_hand", {
        wield_image = "shapetester_hand_tree_monster.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:lava_flan_hand", {
        wield_image = "shapetester_hand_lava_flan.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:land_guard_hand", {
        wield_image = "shapetester_hand_land_guard.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:fire_spirit_hand", {
        wield_image = "fire_basic_flame.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:horse_hand", {
        wield_image = "shapetester_hand_horse.png",
        tool_capabilities = creative_mining
    })

    hands.register_hand("shapetester:cube_hand", {
        wield_image = "shapetester_hand_cube.png",
        tool_capabilities = creative_mining
    })
end

--Reset hand when join
core.register_on_joinplayer(function(player)
    shapetester.reset_hand(player)
end)

--Global functions

--Reset player model
function shapetester.reset(player)
    player:set_properties({
		textures = {"character.png"},
		visual = "mesh",
        mesh = "character.b3d",
		collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	    stepheight = 0.6,
	    eye_height = 1.47,
        visual_size = {x = 1, y = 1, z = 1},
	})
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1,speed = 1,jump = 1})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    shapetester.reset_hand(player)
end

--Sparks effect (if setting enabled)
function shapetester.sparks(player)
    if core.settings:get_bool("shapeshift_sparks", true) then
        local pos = player:get_pos()
	    core.add_particlespawner({
	    	amount = 100,
	    	time = 0.5,
	    	minpos = pos,
	    	maxpos = {x=pos.x,y=pos.y+1,z=pos.z},
	    	minvel = {x=2, y=0.2, z=2},
	    	maxvel = {x=-2, y=2, z=-2},
	    	minacc = {x=0, y=-6, z=0},
	    	maxacc = {x=0, y=-10, z=0},
	    	minexptime = 0.2,
	    	maxexptime = 1,
	    	minsize = 0.3,
	    	maxsize = 2.5,
	    	collisiondetection = true,
	    	texture = "shapetester_particle.png",
            glow = 14,
	    })
    end
end

--Mob functions (local)
--TODO fix animations

--mobs_animal
local function bunny(player)
    player:set_properties({
		textures = {"mobs_bunny_white.png"},
		visual = "mesh",
        mesh = "mobs_bunny.b3d",
		stepheight = 0.6,
	    collisionbox = {-0.268, -0.5, -0.268, 0.268, 0.167, 0.268},
	    eye_height = 0.3,
        visual_size = {x = 1, y = 1, z = 1},
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 0.9,speed = 2.5,jump = 2})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:bunny_hand")
end

local function panda(player)
    player:set_properties({
		textures = {"mobs_panda.png"},
		visual = "mesh",
        mesh = "mobs_panda.b3d",
		stepheight = 0.6,
	    collisionbox = {-0.4, -0.45, -0.4, 0.4, 0.45, 0.4},
	    eye_height = 0.5,
        visual_size = {x = 1, y = 1, z = 1},
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1.1,speed = 0.75,jump = 0.825})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:panda_hand")
end

local function chicken(player)
    player:set_properties({
		textures = {"mobs_chicken.png"},
		visual = "mesh",
        mesh = "mobs_chicken.b3d",
		stepheight = 0.6,
	    collisionbox = {-0.3, -0.75, -0.3, 0.3, 0.1, 0.3},
	    eye_height = 0.55,
        visual_size = {x = 1, y = 1, z = 1},
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 0.6,speed = 2.2,jump = 1.2})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:chicken_hand")
end

local function cow(player)
    player:set_properties({
		textures = {"mobs_cow.png"},
		visual = "mesh",
        mesh = "mobs_cow.b3d",
		stepheight = 0.6,
	    collisionbox = {-0.4, -0.01, -0.4, 0.4, 1.2, 0.4},
	    eye_height = 1.2,
        visual_size = {x = 1, y = 1, z = 1},
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1.15,speed = 0.7,jump = 0.8})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:cow_hand")
end

local function bee(player)
    player:set_properties({
		textures = {"mobs_bee.png"},
		visual = "mesh",
        mesh = "mobs_bee.b3d",
		stepheight = 0.1,
	    collisionbox = {-0.2, -0.01, -0.2, 0.2, 0.5, 0.2},
	    eye_height = 0.5,
        visual_size = {x = 1, y = 1, z = 1},
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 0.5,speed = 5,jump = 3})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:bee_hand")
end

local function kitten(player)
    player:set_properties({
		textures = {"mobs_kitten_ginger.png"},
		visual = "mesh",
        mesh = "mobs_kitten.b3d",
		stepheight = 1.1,
	    collisionbox = {-0.3, -0.3, -0.3, 0.3, 0.1, 0.3},
	    eye_height = 0.5,
        visual_size = {x = 1, y = 1, z = 1},
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1,speed = 2,jump = 1.5})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:kitten_hand")
end

local function rat(player)
    player:set_properties({
		textures = {"mobs_rat.png"},
		visual = "mesh",
        mesh = "mobs_rat.b3d",
		stepheight = 1.1,
	    collisionbox = {-0.2, -1, -0.2, 0.2, -0.8, 0.2},
	    eye_height = 0.5,
        visual_size = {x = 1, y = 1, z = 1},
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 0.85,speed = 3,jump = 1.1})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:rat_hand")
end

local function sheep(player)
    player:set_properties({
		textures = {"mobs_sheep_base.png^mobs_sheep_wool.png"},
		visual = "mesh",
        mesh = "mobs_sheep.b3d",
		stepheight = 0.6,
	    collisionbox = {-0.5, -1, -0.5, 0.5, 0.3, 0.5},
	    eye_height = 0.3,
        visual_size = {x = 1, y = 1, z = 1},
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1,speed = 1.1,jump = 1})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:sheep_hand")
end

local function warthog(player)
    player:set_properties({
		textures = {"mobs_pumba.png"},
		visual = "mesh",
        mesh = "mobs_pumba.b3d",
	    stepheight = 0.6,
	    collisionbox = {-0.4, -0.01, -0.4, 0.4, 0.95, 0.4},
	    eye_height = 1,
        visual_size = {x = 1, y = 1},
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1,speed = 1.75,jump = 1})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:warthog_hand")
end

local function penguin(player)
    player:set_properties({
		textures = {"mobs_penguin.png"},
		visual = "mesh",
        mesh = "mobs_penguin.b3d",
	    stepheight = 0.6,
	    collisionbox = {-0.2, -0.0, -0.2,  0.2, 0.5, 0.2},
	    eye_height = 1,
        visual_size = {x = 0.25, y = 0.25},
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1,speed = 1.2,jump = 1.2})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:penguin_hand")
end

--mobs_monster
local function spider(player)
    player:set_properties({
		textures = {"mobs_spider_orange.png"},
		visual = "mesh",
        mesh = "mobs_spider.b3d",
	    stepheight = 0.6,
	    collisionbox = {-0.7, -0.5, -0.7, 0.7, 0, 0.7},
	    visual_size = {x = 1, y = 1},
	    eye_height = 0.5,
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 0.9,speed = 2.1,jump = 1.9})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:spider_hand")
end

local function dungeon_master(player)
    player:set_properties({
		textures = {"mobs_dungeon_master.png"},
		visual = "mesh",
        mesh = "mobs_dungeon_master.b3d",
	    stepheight = 1.5,
	    collisionbox = {-0.7, -1, -0.7, 0.7, 1.6, 0.7},
	    eye_height = 2,
        visual_size = {x = 1,y = 1}
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1.1,speed = 0.8,jump = 0.9})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:dungeon_master_hand")
end

local function mese_monster(player)
    player:set_properties({
		textures = {"mobs_mese_monster_purple.png"},
		visual = "mesh",
        mesh = "mobs_mese_monster.b3d",
	    stepheight = 2,
	    collisionbox = {-0.75, -0.5, -0.75, 0.75, 2.5, 0.75},
	    eye_height = 1.5,
	    visual_size = {x = 10, y = 10},
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1,speed = 1.5,jump = 1.5})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:mese_monster_hand")
end

local function oerkki(player)
    player:set_properties({
		textures = {"mobs_oerkki.png"},
		visual = "mesh",
        mesh = "mobs_oerkki.b3d",
	    stepheight = 1,
	    collisionbox = {-0.4, -1, -0.4, 0.4, 0.9, 0.4},
	    eye_height = 1.25,
	    visual_size = {x = 1, y = 1},
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1,speed = 1.25,jump = 1.15})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:oerkki_hand")
end

local function sand_monster(player)
    player:set_properties({
		textures = {"mobs_sand_monster.png"},
		visual = "mesh",
        mesh = "mobs_sand_monster.b3d",
	    stepheight = 1,
	    collisionbox = {-0.4, -1, -0.4, 0.4, 0.8, 0.4},
	    eye_height = 1,
	    visual_size = {x = 1, y = 1},
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1,speed = 1.25,jump = 1})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:sand_monster_hand")
end

local function stone_monster(player)
    player:set_properties({
		textures = {"mobs_stone_monster.png"},
		visual = "mesh",
        mesh = "mobs_stone_monster.b3d",
	    stepheight = 1,
	    collisionbox = {-0.4, -1, -0.4, 0.4, 0.9, 0.4},
	    eye_height = 1,
	    visual_size = {x = 1, y = 1},
    })
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1.1,speed = 1,jump = 1})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:stone_monster_hand")
end

local function dirt_monster(player)
    player:set_properties({
		textures = {"mobs_dirt_monster.png"},
		visual = "mesh",
        mesh = "mobs_stone_monster.b3d",
		stepheight = 1,
	    collisionbox = {-0.4, -1, -0.4, 0.4, 0.9, 0.4},
	    eye_height = 1,
        visual_size = {x = 1, y = 1, z = 1},
	})
    shapetester.sparks(player)
    player:set_physics_override({gravity = 0.9,speed = 1,jump = 1})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:dirt_monster_hand")
end

local function tree_monster(player)
    player:set_properties({
		textures = {"mobs_tree_monster.png"},
		visual = "mesh",
        mesh = "mobs_tree_monster.b3d",
		stepheight = 1.25,
	    collisionbox = {-0.4, -1, -0.4, 0.4, 0.8, 0.4},
	    eye_height = 0.75,
        visual_size = {x = 1, y = 1, z = 1},
	})
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1.1,speed = 1.25,jump = 0.9})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:tree_monster_hand")
end

local function lava_flan(player)
    player:set_properties({
		textures = {"zmobs_lava_flan.png"},
		visual = "mesh",
        mesh = "zmobs_lava_flan.b3d",
		stepheight = 0.5,
	    collisionbox = {-0.5, -0.5, -0.5, 0.5, 1.5, 0.5},
	    eye_height = 1.5,
        visual_size = {x = 1, y = 1, z = 1},
	})
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1.1,speed = 2,jump = 0.95})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:lava_flan_hand")
end

local function land_guard(player)
    player:set_properties({
		textures = {"mobs_land_guard.png"},
		visual = "mesh",
        mesh = "mobs_dungeon_master.b3d",
		stepheight = 1.25,
	    collisionbox = {-0.5, -1.01, -0.5, 0.5, 1.6, 0.5},
	    eye_height = 2,
        visual_size = {x = 1, y = 1, z = 1},
	})
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1.15,speed = 0.9,jump = 0.8})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:land_guard_hand")
end

local function fire_spirit (player)
    player:set_properties({
		textures = {"fire_basic_flame.png"},
		visual = "upright_sprite",
		collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
	    visual_size = {x = 0.5, y = 0.5, z = 0.5},
		stepheight = 0.6,
		eye_height = 1,
	})
    shapetester.sparks(player)
    player:set_physics_override({gravity = 0.1,speed = 5,jump = 1.2})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:fire_spirit_hand")
end

--mob_horse
local function horse(player)
    player:set_properties({
		textures = {"mobs_horse.png"},
		visual = "mesh",
        mesh = "mobs_horse.x",
		stepheight = 1.5,
	    collisionbox = {-0.4, -0.01, -0.4, 0.4, 1.25, 0.4},
	    eye_height = 1.5,
	    visual_size = {x = 1.20, y = 1.20},
	})
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1,speed = 4,jump = 1.75})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:horse_hand")
end

--shapetester
local function cube(player)
    player:set_properties({
		visual = "mesh",
		mesh = "shapetester_cube.obj",
		textures = {
			"shapetester_cube.png",
		},
		stepheight = 0.6,
	    collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
	    eye_height = 0.5,
        visual_size = {x = 1, y = 1, z = 1},
	})
    shapetester.sparks(player)
    player:set_physics_override({gravity = 1,speed = 1,jump = 1})
    core.sound_play("shapetester_shift", {gain = 0.4,max_hear_distance = 16})
    sethand(player,"shapetester:cube_hand")
end

--Shapeshift menus
function shapetester.shapeshift_menu_form(player)
    local formspec = {
        "size[9.5,4.5]",
        "background[0,0;0,0;shapetester_menu.png;true]"..
        "button[0,0;1.6,0.8;reset;"..S("Reset").."]",
        "button[1.59,0;1.6,0.8;bunny;"..S("Bunny").."]",
        "button[3.18,0;1.6,0.8;chicken;"..S("Chicken").."]",
        "button[4.77,0;1.6,0.8;cow;"..S("Cow").."]",
        "button[6.36,0;1.6,0.8;bee;"..S("Bee").."]",
        "button[7.95,0;1.6,0.8;kitten;"..S("Kitten").."]",
		"button[0,1;1.6,0.8;panda;"..S("Panda").."]",
		"button[1.59,1;1.6,0.8;rat;"..S("Rat").."]",
		"button[3.18,1;1.6,0.8;sheep;"..S("Sheep").."]",
		"button[4.77,1;1.6,0.8;warthog;"..S("Warthog").."]",
		"button[6.36,1;1.6,0.8;penguin;"..S("Penguin").."]",
        "button[7.95,1;1.6,0.8;dirt_monster;"..S("Dirt monster").."]",
        "button[0,2;1.6,0.8;stone_monster;"..S("Stone monster").."]",
        "button[1.59,2;1.6,0.8;sand_monster;"..S("Sand monster").."]",
        "button[3.18,2;1.6,0.8;tree_monster;"..S("Tree monster").."]",
        "button[4.77,2;1.6,0.8;spider;"..S("Spider").."]",
        "button[6.36,2;1.6,0.8;land_guard;"..S("Land guard").."]",
        "button[7.95,2;1.6,0.8;mese_monster;"..S("Mese monster").."]",
        "button[0,3;1.6,0.8;lava_flan;"..S("Lava flan").."]",
        "button[1.59,3;1.6,0.8;oerkki;"..S("Oerkki").."]",
        "button[3.18,3;1.6,0.8;dungeon_master;"..S("Dungeon master").."]",
        "button[4.77,3;1.6,0.8;fire_spirit;"..S("Fire spirit").."]",
        "button[6.36,3;1.6,0.8;horse;"..S("Horse").."]",
        "button[7.95,3;1.6,0.8;cube;"..S("Cube").."]",
        "button[3.975,4;1.6,0.8;close;"..S("Close").."]",
    }
    return table.concat(formspec, "")
end

--Menu buttons functionalities
core.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= "shapetester:shapeshift_menu" then
        return
    end
    if fields.close then
        core.close_formspec(player:get_player_name(), formname)
    end
    if fields.reset then
		shapetester.reset(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
	if fields.bunny then
		bunny(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
	if fields.chicken then
		chicken(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.cow then
		cow(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.bee then
		bee(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.kitten then
		kitten(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
	if fields.panda then
		panda(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
	if fields.rat then
		rat(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
	if fields.sheep then
		sheep(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
	if fields.warthog then
		warthog(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
	if fields.penguin then
		penguin(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.dirt_monster then
		dirt_monster(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.stone_monster then
		stone_monster(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.sand_monster then
		sand_monster(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.tree_monster then
		tree_monster(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.spider then
		spider(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.land_guard then
		land_guard(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.mese_monster then
		mese_monster(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.lava_flan then
		lava_flan(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.oerkki then
		oerkki(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.dungeon_master then
		dungeon_master(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.fire_spirit then
		fire_spirit(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.horse then
		horse(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
    if fields.cube then
		cube(player)
        local pos = player:get_pos()
        player:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
	end
end)

--Show menu function (global)
function shapetester.show_shapeshift_menu(player)
    core.show_formspec(player, "shapetester:shapeshift_menu", shapetester.shapeshift_menu_form(player))
end

--Player dies, reset model
core.register_on_dieplayer(function(player)
    shapetester.reset(player)
end)