--Get Translator
local S = core.get_translator("shapetester")

--Global variable
shapetester = {}

local use_old_code = core.settings:get_bool("shapetester_use_old_code",false)
local default_shapeshift_sound = core.settings:get("shapetester_default_sound") or "shapetester_shift"

--Get files
local modpath = core.get_modpath("shapetester")
dofile(modpath..("/api.lua"))

if use_old_code == true then
    dofile(modpath..("/old/shapeshift.lua"))
    dofile(modpath..("/old/misc.lua"))
else
    dofile(modpath..("/shapeshift.lua"))
    dofile(modpath..("/misc.lua"))
    dofile(modpath..("/recipes.lua"))
end

if use_old_code == true then
    --Nothing
else
    core.register_privilege("shapeshift", {
        give_to_singleplayer = true,
        give_to_admin = true,
    })
end

if use_old_code == true then
    core.register_chatcommand("shapeshift", {
        privs = {server = true},
        func = shapetester.show_shapeshift_menu,
        description = S("Use this command to show the shape-shift menu")
    })

    core.register_chatcommand("tech_shapeshift", {
        privs = {server = true},
        func = shapetester.show_shapeshift_tech_menu,
        description = S("Use this command to show the technical shape-shift menu")
    })

    core.register_chatcommand("model_reset", {
        privs = {server = true},
        func = function(caller)
            local player = core.get_player_by_name(caller)
            shapetester.reset(player)
        end,
        description = S("Use this command to reset your form/model")
    })
else
    core.register_chatcommand("shapeshift", {
        privs = {shapeshift = true},
        func = function(name,params)
            local player = core.get_player_by_name(name)
            shapetester.menu_pages[name] = 1
            local formspec = shapetester.get_formspec(player)
            core.show_formspec(name, "shapetester:form", formspec)
        end,
        description = S("Use this command to show the shape-shift menu")
    })
    core.register_chatcommand("model_reset", {
        privs = {shapeshift = true},
        func = function(caller)
            local caller = core.get_player_by_name(caller)
            shapetester.reset(caller)
            local pos = caller:get_pos()
            caller:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
            core.sound_play(default_shapeshift_sound, {gain = 0.4,max_hear_distance = 16})
        end,
        description = S("Use this command to reset your form/model")
    })
    core.register_chatcommand("complete_reset", {
        privs = {shapeshift = true},
        func = function(caller)
            local caller = core.get_player_by_name(caller)
            shapetester.complete_reset(caller)
            local pos = caller:get_pos()
            caller:set_pos({x = pos.x,y = pos.y+1,z = pos.z})
            core.sound_play(default_shapeshift_sound, {gain = 0.4,max_hear_distance = 16})
        end,
    })
    core.register_chatcommand("tech_shapeshift", {
        privs = {shapeshift = true},
        func = shapetester.show_shapeshift_tech_menu,
        description = S("Use this command to show the technical shape-shift menu")
    })
end