# Shapetester

## TODO

Features that I eventually want to try and add

1) Add support for 3darmor
2) Add support for skinsdb
3) Add support for Voxelibre and Mineclonia
4) Add support for Repixture
5) Animation fixes

## API

Shapetester has an api to allow you to register your own shapeshifts.

### Registering a shapeshift

To register a shapeshift you can do the following example:

```
local S = core.get_translator("shapetester") --Translator for description

shapetester.register_shapeshift("shapetester:cube",{ -- The name of the shapeshift (just like when registering a node)
    description = S("Cube"), -- The description that will show up in the shapeshift menu
    textures = {"shapetester_cube.png"}, -- The textures of the model
    visual = "mesh", -- The visual type eg. "mesh" or "upright_sprite" 
    mesh = "shapetester_cube.obj", -- The model (if the visual type is mesh)
    stepheight = 0.6, --The step height
    collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5}, -- The collision box
    eye_height = 0.5, -- Eye height
    visual_size = {x = 1, y = 1, z = 1}, -- visual size
    shown_in_shapeshift_tool = true, -- If the shapeshift will be shown in shapetester's shapeshift menu
    gravity = 1, -- Gravity
    speed = 1, -- Speed
    jump = 1, -- Jump
    hand = { -- How the hand will look and function for this shapeshift
        texture = "shapetester_hand_cube.png", -- Hand image
        scale = {x=1,y=1,z=1}, -- scale of the hand
        tool_capabilities = {
		    full_punch_interval = 0.9, -- full punch interval of the hand
		    max_drop_level = 0,
		    groupcaps = { -- What nodes the hand can mine and how quickly
		    	crumbly = {times={[2]=3.00, [3]=0.70}, uses=0, maxlevel=1},
		    	snappy = {times={[3]=0.40}, uses=0, maxlevel=1},
		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
		    },
		    damage_groups = {fleshy=1}, -- How much damage the hand does
	    }
    },
    aux1_cooldown = 4, -- The time between use of the aux1 special
    aux1_special = function(player,name,def) --the arguments for aux1_special are player , name and def  -- Function value, when aux1 is pressed
        core.chat_send_player(player:get_player_name(),"You can put anything in this function!")
    end,
    animation = { -- Animation (WIP)
        idle = {x=0,y=0},
        walk = {x=0,y=0},
        dig = {x=0,y=0},
        walk_while_dig = {x=0,y=0},
        frame_speed = 30
    },
    custom_transform_noise = true, -- if you want a custom transform noise
    transform_noise = "shapetester_shift"
})
```

If `shown_in_shapeshift_tool = true` then it should appear in the shapeshift menu automatically

#### Unregistering a shapeshift

You can unregister registered shapeshifts

`shapetester.unregister_shapeshift(shapeshift)`

`shapeshift` - the name of the shapeshift you want to unregister

#### Overriding a shapeshift

You can also override registered shapeshifts

`shapetester.override_shapeshift(shapeshift,new_def)`

`shapeshift` - the name of the shapeshift you want to override

`new_def` - the new definition of the shapeshift

### Transformation

You can transform specific players with

`shapetester.transform(player_name,shapeshift)`

Example:

```
local name = "bob"
local player = core.get_player_by_name(name)

shapetester.transform(name,"shapetester:cube") -- The shapeshift argument refers to the name of the specified shapeshift

--Optional (for sound and sparks effects)
if core.settings:get_bool("shapeshift_sparks") == false then
    --Nothing
else
    shapetester.sparks(player)
end
--Plays the default shapeshift sound
shapetester.sound(player)
```

### Other functions

There are many other functions in the API including:

`shapetester.sparks(player) -- Creates sparks at the specified player (the player argument for the function)`

`shapetester.reset(player) -- Resets the specified player's model to character.b3d, and their texture to character.png (which means it will only reset properly if those files exist)`

`shapetester.complete_reset(player) -- Resets the specified player to the engine default player defenition`

`shapetester.registered_shapeshifts -- This is a variable much like core.registered_items but for all registered shapeshifts instead`

## Dependencies

Shapetester has no hard dependencies

But Shapetester has many optional dependencies like:

1) mobs_animal
2) mobs_monster
3) mob_horse
4) default

## Licenses

See LICENSE.md in Shapetester's mod folder

## Old code

In Shapetester's settings, you can toggle old code on and off (for old code you will have to enable mobs_animal, mobs_monster, mob_horse , hands and default or it won't work)

[Mobs animal](https://content.luanti.org/packages/TenPlus1/mobs_animal/),
[Mobs monster](https://content.luanti.org/packages/TenPlus1/mobs_monster/),
[Mob horse](https://content.luanti.org/packages/TenPlus1/mob_horse/),
[Interchangeable hands](https://content.luanti.org/packages/octacian/hands/),

Compatible games for old code

1) [Minetest Game](https://content.luanti.org/packages/Luanti/minetest_game/)

2) [yams RPG](https://content.luanti.org/packages/jara25/yams/) - Armor doesn't work 

## Shapeshifting

You can craft the shapeshifting tool to transform or you can use the shapeshift command

For the shapeshift command, just open the chat and type: `/shapeshift`, then press enter (you must have the **shapeshift** privilege)

Or you can use the shapeshift tool

To create your own shapeshifts you can use the shapeshift computer which will open the technical shapeshift menu (For this tool you will need the **shapeshift** privilege)

Or you can use the `/tech_shapeshift` command (you must have the **shapeshift** privilege)

You can also use the `/model_reset` (the **shapeshift** privilege is also needed) command which has the same function as the `shapetester.reset` function