local S = core.get_translator("shapetester")

--Settings:
local animals = core.settings:get("shapetester_animals",true)
local monsters = core.settings:get("shapetester_monsters",true)
local horse = core.settings:get("shapetester_horse",true)

--Base shapeshifts:
--mobs_animal, mob_horse and mobs_monster

if core.get_modpath("mobs_animal") and animals == true or core.get_modpath("mobs_animal") and animals == nil then
    shapetester.register_shapeshift("shapetester:bunny",{
        description = S("Bunny"),
        textures = {"mobs_bunny_white.png"},
        visual = "mesh",
        mesh = "mobs_bunny.b3d",
        stepheight = 0.6,
        collisionbox = {-0.268, -0.5, -0.268, 0.268, 0.167, 0.268},
        eye_height = 0.1,
        visual_size = {x = 1, y = 1, z = 1},
        shown_in_shapeshift_tool = true,
        gravity = 0.9,
        speed = 2.5,
        jump = 2,
        animation = {
            idle = {x = 0, y = 0},
            walk = {x = 0,y = 79},
            dig = {x = 0, y = 0},
            walk_while_dig = {x = 0,y = 79},
            frame_speed = 50
        },
        hand = {
            texture = "shapetester_hand_bunny.png",
            scale = {x=1,y=1,z=1.5},
            tool_capabilities = {
    		    full_punch_interval = 0.9,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[2]=3.00, [3]=0.80}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=0.50}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=1},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:panda",{
        description = S("Panda"),
        textures = {"mobs_panda.png"},
        visual = "mesh",
        mesh = "mobs_panda.b3d",
        stepheight = 0.6,
        collisionbox = {-0.4, -0.45, -0.4, 0.4, 0.45, 0.4},
        eye_height = 0.5,
        visual_size = {x = 1, y = 1, z = 1},
        shown_in_shapeshift_tool = true,
        gravity = 1.1,
        speed = 0.75,
        jump = 0.825,
        hand = {
            texture = "shapetester_hand_panda.png",
            scale = {x=1,y=1,z=3},
            tool_capabilities = {
    		    full_punch_interval = 1.5,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[2]=3.00, [3]=0.50}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=0.40}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=4},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:chicken",{
        description = S("Chicken"),
        textures = {"mobs_chicken.png"},
        visual = "mesh",
        mesh = "mobs_chicken.b3d",
        stepheight = 0.6,
        collisionbox = {-0.3, -0.75, -0.3, 0.3, 0.1, 0.3},
        eye_height = 0.55,
        visual_size = {x = 1, y = 1, z = 1},
        shown_in_shapeshift_tool = true,
        gravity = 0.6,
        speed = 2.2,
        hand = {
            texture = "shapetester_hand_chicken.png",
            scale = {x=1,y=1,z=1},
            tool_capabilities = {
    		    full_punch_interval = 1.2,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[2]=3.00, [3]=0.50}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=0.40}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=4},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:cow",{
        description = S("Cow"),
        textures = {"mobs_cow.png"},
        visual = "mesh",
        mesh = "mobs_cow.b3d",
        stepheight = 0.6,
        collisionbox = {-0.4, -0.01, -0.4, 0.4, 1.2, 0.4},
        eye_height = 1.2,
        visual_size = {x = 1, y = 1, z = 1},
        shown_in_shapeshift_tool = true,
        gravity = 1.15,
        speed = 0.7,
        jump = 0.8,
        hand = {
            texture = "shapetester_hand_cow.png",
            scale = {x=1,y=1,z=3.5},
            tool_capabilities = {
    		    full_punch_interval = 1.5,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[2]=3.00, [3]=0.80}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=0.70}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=6},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:bee",{
        description = S("Bee"),
        textures = {"mobs_bee.png"},
        visual = "mesh",
        mesh = "mobs_bee.b3d",
        stepheight = 0.1,
        collisionbox = {-0.2, -0.01, -0.2, 0.2, 0.5, 0.2},
        eye_height = 0.5,
        visual_size = {x = 1, y = 1, z = 1},
        shown_in_shapeshift_tool = true,
        gravity = 0.5,
        speed = 5,
        jump = 3,
        hand = {
            texture = "shapetester_hand_bee.png",
            scale = {x=1,y=1,z=0.5},
            tool_capabilities = {
    		    full_punch_interval = 0.1,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[3]=3}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=2}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=1},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:kitten",{
        description = S("Kitten"),
        textures = {"mobs_kitten_ginger.png"},
        visual = "mesh",
        mesh = "mobs_kitten.b3d",
        stepheight = 1.1,
        collisionbox = {-0.3, -0.3, -0.3, 0.3, 0.1, 0.3},
        eye_height = 0.5,
        visual_size = {x = 1, y = 1, z = 1},
        shown_in_shapeshift_tool = true,
        gravity = 1,
        speed = 2,
        jump = 1.5,
        hand = {
            texture = "shapetester_hand_kitten.png",
            scale = {x=1,y=1,z=2},
            tool_capabilities = {
    		    full_punch_interval = 0.6,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[2]=3,[3]=0.7}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=0.5}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=2},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:rat",{
        description = S("Rat"),
        textures = {"mobs_rat.png"},
        visual = "mesh",
        mesh = "mobs_rat.b3d",
        stepheight = 1.1,
        collisionbox = {-0.2, -1, -0.2, 0.2, -0.8, 0.2},
        eye_height = 0.05,
        visual_size = {x = 1, y = 1, z = 1},
        shown_in_shapeshift_tool = true,
        gravity = 0.85,
        speed = 3,
        jump = 1.1,
        hand = {
            texture = "shapetester_hand_rat.png",
            scale = {x=1,y=1,z=1},
            tool_capabilities = {
    		    full_punch_interval = 0.5,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[3]=2.9}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=1.1}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=1},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:sheep",{
        description = S("Sheep"),
        textures = {"mobs_sheep_base.png^mobs_sheep_wool.png"},
        visual = "mesh",
        mesh = "mobs_sheep.b3d",
        stepheight = 0.6,
        collisionbox = {-0.5, -1, -0.5, 0.5, 0.3, 0.5},
        eye_height = 0.3,
        visual_size = {x = 1, y = 1, z = 1},
        shown_in_shapeshift_tool = true,
        gravity = 1,
        speed = 1.1,
        jump = 1,
        hand = {
            texture = "shapetester_hand_sheep.png",
            scale = {x=1,y=1,z=2.5},
            tool_capabilities = {
    		    full_punch_interval = 1.3,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[2]=3,[3]=2}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=1}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=2},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:warthog",{
        description = S("Warthog"),
        textures = {"mobs_pumba.png"},
        visual = "mesh",
        mesh = "mobs_pumba.b3d",
        stepheight = 0.6,
        collisionbox = {-0.4, -0.01, -0.4, 0.4, 0.95, 0.4},
        eye_height = 1,
        visual_size = {x = 1, y = 1, z = 1},
        shown_in_shapeshift_tool = true,
        gravity = 1,
        speed = 1.75,
        jump = 1,
        hand = {
            texture = "shapetester_hand_sheep.png",
            scale = {x=1,y=1,z=1.5},
            tool_capabilities = {
    		    full_punch_interval = 1,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[2]=1,[3]=0.75}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=1}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=4},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:penguin",{
        description = S("Penguin"),
        textures = {"mobs_penguin.png"},
        visual = "mesh",
        mesh = "mobs_penguin.b3d",
        stepheight = 0.6,
        collisionbox = {-0.2, -0.0, -0.2,  0.2, 0.5, 0.2},
        eye_height = 0.7,
        visual_size = {x = 0.25, y = 0.25},
        shown_in_shapeshift_tool = true,
        gravity = 1,
        speed = 1.2,
        jump = 1.2,
        hand = {
            texture = "shapetester_hand_penguin.png",
            scale = {x=1,y=1,z=0.5},
            tool_capabilities = {
    		    full_punch_interval = 0.6,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[2]=3,[3]=2}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=1}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=1},
    	    }
        }
    })
end

if core.get_modpath("mobs_monster") and monsters == true or core.get_modpath("mobs_monster") and monsters == nil then
    shapetester.register_shapeshift("shapetester:spider",{
        description = S("Spider"),
        textures = {"mobs_spider_orange.png"},
        visual = "mesh",
        mesh = "mobs_spider.b3d",
        stepheight = 0.6,
        collisionbox = {-0.7, -0.5, -0.7, 0.7, 0, 0.7},
        eye_height = 0.5,
        visual_size = {x = 1, y = 1},
        shown_in_shapeshift_tool = true,
        gravity = 0.9,
        speed = 2.1,
        jump = 1.9,
        hand = {
            texture = "shapetester_hand_spider.png",
            scale = {x=1,y=1,z=0.5},
            tool_capabilities = {
    		    full_punch_interval = 0.6,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[2]=2,[3]=1}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=0.5}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=6},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:dungeon_master",{
        description = S("Dungeon master"),
        textures = {"mobs_dungeon_master.png"},
        visual = "mesh",
        mesh = "mobs_dungeon_master.b3d",
        stepheight = 1.5,
        collisionbox = {-0.7, -1, -0.7, 0.7, 1.6, 0.7},
        eye_height = 2,
        visual_size = {x = 1, y = 1},
        shown_in_shapeshift_tool = true,
        gravity = 1.1,
        speed = 0.8,
        jump = 0.9,
        aux1_cooldown = 4,
        aux1_special = function(player,name,def)
            local pos = player:get_pos()
            local projectile = core.add_entity({x=pos.x,y=pos.y+1.3,z=pos.z}, "mobs_monster:fireball")
            local luaentity = projectile:get_luaentity()
            projectile:set_velocity(player:get_look_dir()*(luaentity.velocity))
            luaentity.owner = player:get_player_name()
        end,
        hand = {
            texture = "shapetester_hand_dungeon_master.png",
            scale = {x=1,y=1,z=4},
            tool_capabilities = {
    		    full_punch_interval = 1,
    		    max_drop_level = 0,
    		    groupcaps = {
                    cracky = {times={[2]=3,[3]=2}, uses=0, maxlevel=1},
    		    	crumbly = {times={[2]=1,[3]=0.5}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=0.25}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=11},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:mese_monster",{
        description = S("Mese monster"),
        textures = {"mobs_mese_monster_purple.png"},
        visual = "mesh",
        mesh = "mobs_mese_monster.b3d",
        stepheight = 2,
        collisionbox = {-0.75, -0.5, -0.75, 0.75, 2.5, 0.75},
        eye_height = 1.5,
        visual_size = {x = 10, y = 10},
        shown_in_shapeshift_tool = true,
        gravity = 1,
        speed = 1.5,
        jump = 1.5,
        aux1_cooldown = 0.5,
        aux1_special = function(player,name,def)
            local pos = player:get_pos()
            local projectile = core.add_entity({x=pos.x,y=pos.y+1.3,z=pos.z}, "mobs_monster:mese_arrow")
            local luaentity = projectile:get_luaentity()
            projectile:set_velocity(player:get_look_dir()*(luaentity.velocity))
            luaentity.owner = player:get_player_name()
        end,
        hand = {
            texture = "shapetester_hand_mese_monster.png",
            scale = {x=1,y=1,z=1},
            tool_capabilities = {
    		    full_punch_interval = 0.6,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[2]=1,[3]=0.5}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=0.25}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=7},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:oerkki",{
        description = S("Oerkki"),
        textures = {"mobs_oerkki.png"},
        visual = "mesh",
        mesh = "mobs_oerkki.b3d",
        stepheight = 1,
        collisionbox = {-0.4, -1, -0.4, 0.4, 0.9, 0.4},
        eye_height = 1.25,
        visual_size = {x = 1, y = 1},
        shown_in_shapeshift_tool = true,
        gravity = 1,
        speed = 1.25,
        jump = 1.15,
        hand = {
            texture = "shapetester_hand_oerkki.png",
            scale = {x=1,y=1,z=2},
            tool_capabilities = {
    		    full_punch_interval = 0.8,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[2]=2,[3]=1}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=0.5}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=10},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:sand_monster",{
        description = S("Sand monster"),
        textures = {"mobs_sand_monster.png"},
        visual = "mesh",
        mesh = "mobs_sand_monster.b3d",
        stepheight = 1,
        collisionbox = {-0.4, -1, -0.4, 0.4, 0.8, 0.4},
        eye_height = 1,
        visual_size = {x = 1, y = 1},
        shown_in_shapeshift_tool = true,
        gravity = 1,
        speed = 1.25,
        jump = 1,
        hand = {
            texture = "shapetester_hand_sand_monster.png",
            scale = {x=1,y=1,z=1},
            tool_capabilities = {
    		    full_punch_interval = 0.9,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[2]=3,[3]=2}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=0.75}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=6},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:stone_monster",{
        description = S("Stone monster"),
        textures = {"mobs_stone_monster.png"},
        visual = "mesh",
        mesh = "mobs_stone_monster.b3d",
        stepheight = 1,
        collisionbox = {-0.4, -1, -0.4, 0.4, 0.9, 0.4},
        eye_height = 1,
        visual_size = {x = 1, y = 1},
        shown_in_shapeshift_tool = true,
        gravity = 1.1,
        speed = 1,
        jump = 1,
        hand = {
            texture = "shapetester_hand_stone_monster.png",
            scale = {x=1,y=1,z=2},
            tool_capabilities = {
    		    full_punch_interval = 1,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[2]=2,[3]=1}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=1}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=7},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:dirt_monster",{
        description = S("Dirt monster"),
        textures = {"mobs_dirt_monster.png"},
        visual = "mesh",
        mesh = "mobs_stone_monster.b3d",
        stepheight = 1,
        collisionbox = {-0.4, -1, -0.4, 0.4, 0.9, 0.4},
        eye_height = 1,
        visual_size = {x = 1, y = 1},
        shown_in_shapeshift_tool = true,
        gravity = 0.9,
        speed = 1,
        jump = 1,
        hand = {
            texture = "shapetester_hand_dirt_monster.png",
            scale = {x=1,y=1,z=2},
            tool_capabilities = {
    		    full_punch_interval = 1,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[2]=2,[3]=1}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=1}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=5},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:tree_monster",{
        description = S("Tree monster"),
        textures = {"mobs_tree_monster.png"},
        visual = "mesh",
        mesh = "mobs_tree_monster.b3d",
        stepheight = 1.25,
        collisionbox = {-0.4, -1, -0.4, 0.4, 0.8, 0.4},
        eye_height = 0.75,
        visual_size = {x = 1, y = 1},
        shown_in_shapeshift_tool = true,
        gravity = 1.1,
        speed = 1.25,
        jump = 0.9,
        hand = {
            texture = "shapetester_hand_tree_monster.png",
            scale = {x=1,y=1,z=3},
            tool_capabilities = {
    		    full_punch_interval = 1,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	crumbly = {times={[2]=2,[3]=1}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=1}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=8},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:lava_flan",{
        description = S("Lava flan"),
        textures = {"zmobs_lava_flan.png"},
        visual = "mesh",
        mesh = "zmobs_lava_flan.b3d",
        stepheight = 0.5,
        collisionbox = {-0.5, -0.5, -0.5, 0.5, 1.5, 0.5},
        eye_height = 1.5,
        visual_size = {x = 1, y = 1},
        shown_in_shapeshift_tool = true,
        gravity = 1.1,
        speed = 2,
        jump = 0.95,
        aux1_cooldown = 3,
        aux1_special = function(player,name,def)
            local pos = player:get_pos()
            local projectile = core.add_entity({x=pos.x,y=pos.y+1.35,z=pos.z}, "mobs_monster:obsidian_arrow")
            local luaentity = projectile:get_luaentity()
            projectile:set_velocity(player:get_look_dir()*(luaentity.velocity))
            luaentity.owner = player:get_player_name()
        end,
        hand = {
            texture = "shapetester_hand_lava_flan.png",
            scale = {x=1,y=1,z=5},
            tool_capabilities = {
    		    full_punch_interval = 1,
    		    max_drop_level = 0,
    		    groupcaps = {
                    cracky = {times={[3]=3}, uses=0, maxlevel=1},
    		    	crumbly = {times={[2]=2,[3]=1}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=1}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=9},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:land_guard",{
        description = S("Land guard"),
        textures = {"mobs_land_guard.png"},
        visual = "mesh",
        mesh = "mobs_dungeon_master.b3d",
        stepheight = 1.25,
        collisionbox = {-0.5, -1.01, -0.5, 0.5, 1.6, 0.5},
        eye_height = 2,
        visual_size = {x = 1, y = 1},
        shown_in_shapeshift_tool = true,
        gravity = 1.15,
        speed = 0.9,
        jump = 0.8,
        hand = {
            texture = "shapetester_hand_land_guard.png",
            scale = {x=1,y=1,z=4},
            tool_capabilities = {
    		    full_punch_interval = 1,
    		    max_drop_level = 0,
    		    groupcaps = {
                    cracky = {times={[3]=2}, uses=0, maxlevel=1},
    		    	crumbly = {times={[2]=1,[3]=0.5}, uses=0, maxlevel=1},
    		    	snappy = {times={[3]=0.25}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=11},
    	    }
        }
    })

    shapetester.register_shapeshift("shapetester:fire_spirit",{
        description = S("Fire spirit"),
        textures = {"fire_basic_flame.png"},
        visual = "upright_sprite",
        stepheight = 0.6,
        collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
        eye_height = 0.5,
        visual_size = {x = 0.5, y = 0.5, z = 0.5},
        shown_in_shapeshift_tool = true,
        gravity = 0.1,
        speed = 5,
        jump = 1.2,
        hand = {
            texture = "fire_basic_flame.png",
            scale = {x=1,y=1,z=0.5},
            tool_capabilities = {
    		    full_punch_interval = 0.1,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	snappy = {times={[3]=1}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=15},
    	    }
        }
    })
end

if core.get_modpath("mob_horse") and horse == true or core.get_modpath("mob_horse") and horse == nil then
    shapetester.register_shapeshift("shapetester:horse",{
        description = S("Horse"),
        textures = {"mobs_horse.png"},
        visual = "mesh",
        mesh = "mobs_horse.x",
        stepheight = 1.5,
        collisionbox = {-0.4, -0.01, -0.4, 0.4, 1.25, 0.4},
        eye_height = 1.5,
        visual_size = {x = 1.20, y = 1.20},
        shown_in_shapeshift_tool = true,
        gravity = 1,
        speed = 4,
        jump = 1.75,
        aux1_cooldown = 2.5,
        aux1_special = function(player,name,def)
            player:set_physics_override({speed = def.speed+1.75})
            core.after(1, function(player)player:set_physics_override({speed = def.speed})end, player)
        end,
        hand = {
            texture = "shapetester_hand_horse.png",
            scale = {x=1,y=1,z=3.5},
            tool_capabilities = {
    		    full_punch_interval = 0.6,
    		    max_drop_level = 0,
    		    groupcaps = {
    		    	snappy = {times={[3]=0.1}, uses=0, maxlevel=1},
    		    	oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
    		    },
    		    damage_groups = {fleshy=8},
    	    }
        }
    })
end