--Arcane bolt
core.register_entity("super_magic:arcane_bolt",{
        initial_properties = {
            physical = false,
            collide_with_objects = true,
            collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
            visual = "sprite",
            visual_size = {x=1,y=1,z=1},
            textures = {"super_magic_bolt.png"},
            spritediv = {x = 1, y = 1},
            initial_sprite_basepos = {x = 0, y = 0},
            glow = 14,
        },
       on_activate = function(self, staticdata)end,
        on_collision = function(self, other, point)
        self.object:remove()
	end,

    on_step = function(self, dtime)
        self.timer = (self.timer or 0) + dtime
		if self.timer > 3 then
			self.object:remove()
        end
        if self.timer > 1 then
			core.sound_play("super_magic_cast", {pos=self.object:get_pos(),gain=0.4,max_hear_distance=16})
        end
        for _,entity in pairs(core.get_objects_inside_radius(self.object:get_pos(),2)) do
            if entity:is_player() and entity:get_player_name() ~= self.owner then
                entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 10}},nil)
            end
            local luaentity = entity:get_luaentity()
            if luaentity and not self.removing then
                if luaentity.name ~= self.object:get_luaentity().name then
                    if entity:get_armor_groups().fleshy then
                        entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 10}},nil)
                    end
                end
            end
        end
        
        local pos = self.object:get_pos()
            core.add_particlespawner({
	    	    amount = 25,
	    	    time = 0.4,
	    	    minpos = pos,
	    	    maxpos = {x=pos.x,y=pos.y+1,z=pos.z},
	    	    minvel = {x=2.1, y=-2.1, z=2},
	    	    maxvel = {x=-2.1, y=2.1, z=-2.1},
	    	    minexptime = 0.2,
	    	    maxexptime = 0.3,
	    	    minsize = 1,
	    	    maxsize = 2.5,
	    	    collisiondetection = true,
	    	    texture = "super_magic_bolt_particle.png",
                glow = 12,
	        })
		self.timer = (self.timer or 0) + dtime
		if self.timer > 1.5 then
			self.object:remove()
        end
    end
})

core.register_entity("super_magic:auto_arcane_bolt",{
        initial_properties = {
            physical = false,
            collide_with_objects = true,
            collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
            visual = "sprite",
            visual_size = {x=1,y=1,z=1},
            textures = {"super_magic_bolt.png"},
            spritediv = {x = 1, y = 1},
            initial_sprite_basepos = {x = 0, y = 0},
            glow = 14,
        },
       on_activate = function(self, staticdata)end,
        on_collision = function(self, other, point)
        self.object:remove()
	end,

    on_step = function(self, dtime)
        self.timer = (self.timer or 0) + dtime
		if self.timer > 3 then
			self.object:remove()
        end
        if self.timer > 1 then
			core.sound_play("super_magic_cast", {pos=self.object:get_pos(),gain=0.4,max_hear_distance=16})
        end
        for _,entity in pairs(core.get_objects_inside_radius(self.object:get_pos(),2)) do
            if entity:is_player() and entity:get_player_name() ~= self.owner then
                entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 3}},nil)
            end
            local luaentity = entity:get_luaentity()
            if luaentity and not self.removing then
                if luaentity.name ~= self.object:get_luaentity().name then
                    if entity:get_armor_groups().fleshy then
                        entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 3}},nil)
                    end
                end
            end
        end
        
        local pos = self.object:get_pos()
            core.add_particlespawner({
	    	    amount = 25,
	    	    time = 0.4,
	    	    minpos = pos,
	    	    maxpos = {x=pos.x,y=pos.y+1,z=pos.z},
	    	    minvel = {x=2.1, y=-2.1, z=2},
	    	    maxvel = {x=-2.1, y=2.1, z=-2.1},
	    	    minexptime = 0.2,
	    	    maxexptime = 0.3,
	    	    minsize = 1,
	    	    maxsize = 2.5,
	    	    collisiondetection = true,
	    	    texture = "super_magic_bolt_particle.png",
                glow = 12,
	        })
		self.timer = (self.timer or 0) + dtime
		if self.timer > 1.5 then
			self.object:remove()
        end
    end
})

--Fire bolt
core.register_entity("super_magic:fire_bolt",{
        initial_properties = {
            physical = false,
            collide_with_objects = true,
            collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
            visual = "sprite",
            visual_size = {x=1,y=1,z=1},
            textures = {"fire_basic_flame.png"},
            spritediv = {x = 1, y = 1},
            initial_sprite_basepos = {x = 0, y = 0},
            glow = 14,
        },
       on_activate = function(self, staticdata)end,
        on_collision = function(self, other, point)
        self.object:remove()
	end,

    on_step = function(self, dtime)
        self.timer = (self.timer or 0) + dtime
		if self.timer > 3.5 then
			self.object:remove()
        end
        if self.timer > 1 then
			core.sound_play("super_magic_cast", {pos=self.object:get_pos(),gain=0.4,max_hear_distance=16})
        end
        local has_exploded = false
        local pos = self.object:get_pos()
        local node = core.get_node_or_nil(pos)
        if node and core.registered_nodes[node.name].walkable then
            tnt.boom(pos,{
                radius = 3
            })
            has_exploded = true
        end

        if has_exploded == false then
        for _,entity in pairs(core.get_objects_inside_radius(self.object:get_pos(),2)) do
            if entity:is_player() and entity:get_player_name() ~= self.owner then
                entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 15}},nil)
            end
            local luaentity = entity:get_luaentity()
            if luaentity and not self.removing then
                if luaentity.name ~= self.object:get_luaentity().name then
                    if entity:get_armor_groups().fleshy then
                        entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 15}},nil)
                    end
                end
            end
        end
    end
        
        local pos = self.object:get_pos()
        if pos then
            core.add_particlespawner({
	    	    amount = 25,
	    	    time = 0.4,
	    	    minpos = pos,
	    	    maxpos = {x=pos.x,y=pos.y+1,z=pos.z},
	    	    minvel = {x=2.1, y=-2.1, z=2},
	    	    maxvel = {x=-2.1, y=2.1, z=-2.1},
	    	    minexptime = 0.2,
	    	    maxexptime = 0.3,
	    	    minsize = 1,
	    	    maxsize = 2.5,
	    	    collisiondetection = true,
	    	    texture = "fire_basic_flame.png",
                glow = 12,
	        })
        end
		self.timer = (self.timer or 0) + dtime
		if self.timer > 1.5 then
			self.object:remove()
        end
    end
})

core.register_entity("super_magic:auto_fire_bolt",{
        initial_properties = {
            physical = false,
            collide_with_objects = true,
            collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
            visual = "sprite",
            visual_size = {x=1,y=1,z=1},
            textures = {"fire_basic_flame.png"},
            spritediv = {x = 1, y = 1},
            initial_sprite_basepos = {x = 0, y = 0},
            glow = 14,
        },
       on_activate = function(self, staticdata)end,
        on_collision = function(self, other, point)
        self.object:remove()
	end,

    on_step = function(self, dtime)
        self.timer = (self.timer or 0) + dtime
		if self.timer > 3.5 then
			self.object:remove()
        end
        if self.timer > 1 then
			core.sound_play("super_magic_cast", {pos=self.object:get_pos(),gain=0.4,max_hear_distance=16})
        end
        local has_exploded = false
        local pos = self.object:get_pos()
        local node = core.get_node_or_nil(pos)
        if node and core.registered_nodes[node.name].walkable then
            tnt.boom(pos,{
                radius = 2
            })
            has_exploded = true
        end

        if has_exploded == false then
        for _,entity in pairs(core.get_objects_inside_radius(self.object:get_pos(),2)) do
            if entity:is_player() and entity:get_player_name() ~= self.owner then
                entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 5}},nil)
            end
            local luaentity = entity:get_luaentity()
            if luaentity and not self.removing then
                if luaentity.name ~= self.object:get_luaentity().name then
                    if entity:get_armor_groups().fleshy then
                        entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 5}},nil)
                    end
                end
            end
        end
    end
        
        local pos = self.object:get_pos()
        if pos then
            core.add_particlespawner({
	    	    amount = 25,
	    	    time = 0.4,
	    	    minpos = pos,
	    	    maxpos = {x=pos.x,y=pos.y+1,z=pos.z},
	    	    minvel = {x=2.1, y=-2.1, z=2},
	    	    maxvel = {x=-2.1, y=2.1, z=-2.1},
	    	    minexptime = 0.2,
	    	    maxexptime = 0.3,
	    	    minsize = 1,
	    	    maxsize = 2.5,
	    	    collisiondetection = true,
	    	    texture = "fire_basic_flame.png",
                glow = 12,
	        })
        end
		self.timer = (self.timer or 0) + dtime
		if self.timer > 1.5 then
			self.object:remove()
        end
    end
})

--Air bolt
core.register_entity("super_magic:air_bolt",{
        initial_properties = {
            physical = false,
            collide_with_objects = true,
            collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
            visual = "sprite",
            visual_size = {x=1,y=1,z=1},
            textures = {"super_magic_air_bolt.png"},
            spritediv = {x = 1, y = 1},
            initial_sprite_basepos = {x = 0, y = 0},
            glow = 14,
        },
       on_activate = function(self, staticdata)end,
        on_collision = function(self, other, point)
        self.object:remove()
	end,

    on_step = function(self, dtime)
        self.timer = (self.timer or 0) + dtime
		if self.timer > 3 then
			self.object:remove()
        end
        if self.timer > 1 then
			core.sound_play("super_magic_cast", {pos=self.object:get_pos(),gain=0.4,max_hear_distance=16})
        end
        local pos = self.object:get_pos()
        local node = core.get_node_or_nil(pos)
        if node and core.registered_nodes[node.name].walkable then
            core.add_particlespawner({
	    	    amount = 100,
	    	    time = 0.5,
	    	    minpos = pos,
	    	    maxpos = {x=pos.x,y=pos.y+1,z=pos.z},
	    	    minvel = {x=2.1, y=-2.1, z=2},
	    	    maxvel = {x=-2.1, y=2.1, z=-2.1},
	    	    minexptime = 0.2,
	    	    maxexptime = 0.3,
	    	    minsize = 3,
	    	    maxsize = 5,
	    	    collisiondetection = true,
	    	    texture = "super_magic_air_bolt_particle.png",
                glow = 10,
	        })
            for _,entity in pairs(core.get_objects_inside_radius(self.object:get_pos(),4)) do
            if entity:is_player() then
                entity:add_player_velocity({x=math.random(-10,10),y=math.random(-10,10),z=math.random(-10,10)})
            end
            local luaentity = entity:get_luaentity()
            if luaentity and not self.removing then
                if luaentity.name ~= self.object:get_luaentity().name then
                    entity:add_velocity({x=math.random(-10,10),y=math.random(-10,10),z=math.random(-10,10)})
                end
            end
        end
        end
        for _,entity in pairs(core.get_objects_inside_radius(self.object:get_pos(),2)) do
            if entity:is_player() then
                entity:add_player_velocity({x=math.random(-10,10),y=math.random(-10,10),z=math.random(-10,10)})
            end
            local luaentity = entity:get_luaentity()
            if luaentity and not self.removing then
                if luaentity.name ~= self.object:get_luaentity().name then
                    entity:add_velocity({x=math.random(-10,10),y=math.random(-10,10),z=math.random(-10,10)})
                end
            end
        end
        
        local pos = self.object:get_pos()
            core.add_particlespawner({
	    	    amount = 25,
	    	    time = 0.4,
	    	    minpos = pos,
	    	    maxpos = {x=pos.x,y=pos.y+1,z=pos.z},
	    	    minvel = {x=2.1, y=-2.1, z=2},
	    	    maxvel = {x=-2.1, y=2.1, z=-2.1},
	    	    minexptime = 0.2,
	    	    maxexptime = 0.3,
	    	    minsize = 1,
	    	    maxsize = 2.5,
	    	    collisiondetection = true,
	    	    texture = "super_magic_air_bolt_particle.png",
                glow = 12,
	        })
		self.timer = (self.timer or 0) + dtime
		if self.timer > 1.5 then
			self.object:remove()
        end
    end
})

--Earth bolt
core.register_entity("super_magic:earth_bolt",{
        initial_properties = {
            physical = false,
            collide_with_objects = true,
            collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
            visual = "sprite",
            visual_size = {x=1,y=1,z=1},
            textures = {"super_magic_earth_bolt.png"},
            spritediv = {x = 1, y = 1},
            initial_sprite_basepos = {x = 0, y = 0},
            glow = 14,
        },
       on_activate = function(self, staticdata)end,
        on_collision = function(self, other, point)
        self.object:remove()
	end,

    on_step = function(self, dtime)
        self.timer = (self.timer or 0) + dtime
		if self.timer > 3 then
			self.object:remove()
        end
        if self.timer > 1 then
			core.sound_play("super_magic_cast", {pos=self.object:get_pos(),gain=0.4,max_hear_distance=16})
        end
        local pos = self.object:get_pos()
        local node = core.get_node_or_nil(pos)
        if node and core.registered_nodes[node.name].walkable then
            core.set_node(pos, {name="default:stone"})
            core.set_node({x=pos.x,y=pos.y+1,z=pos.z}, {name="default:stone"})
        end
        for _,entity in pairs(core.get_objects_inside_radius(self.object:get_pos(),2)) do
            if entity:is_player() and entity:get_player_name() ~= self.owner then
                entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 20}},nil)
            end
            local luaentity = entity:get_luaentity()
            if luaentity and not self.removing then
                if luaentity.name ~= self.object:get_luaentity().name then
                    entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 20}},nil)
                end
            end
        end
		self.timer = (self.timer or 0) + dtime
		if self.timer > 1.5 then
			self.object:remove()
        end
    end
})

core.register_entity("super_magic:auto_earth_bolt",{
        initial_properties = {
            physical = false,
            collide_with_objects = true,
            collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
            visual = "sprite",
            visual_size = {x=1,y=1,z=1},
            textures = {"super_magic_earth_bolt.png"},
            spritediv = {x = 1, y = 1},
            initial_sprite_basepos = {x = 0, y = 0},
            glow = 14,
        },
       on_activate = function(self, staticdata)end,
        on_collision = function(self, other, point)
        self.object:remove()
	end,

    on_step = function(self, dtime)
        self.timer = (self.timer or 0) + dtime
		if self.timer > 3 then
			self.object:remove()
        end
        if self.timer > 1 then
			core.sound_play("super_magic_cast", {pos=self.object:get_pos(),gain=0.4,max_hear_distance=16})
        end
        local pos = self.object:get_pos()
        local node = core.get_node_or_nil(pos)
        if node and core.registered_nodes[node.name].walkable then
            core.set_node(pos, {name="default:stone"})
            core.set_node({x=pos.x,y=pos.y+1,z=pos.z}, {name="default:stone"})
        end
        for _,entity in pairs(core.get_objects_inside_radius(self.object:get_pos(),2)) do
            if entity:is_player() and entity:get_player_name() ~= self.owner then
                entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 7}},nil)
            end
            local luaentity = entity:get_luaentity()
            if luaentity and not self.removing then
                if luaentity.name ~= self.object:get_luaentity().name then
                    entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 7}},nil)
                end
            end
        end
		self.timer = (self.timer or 0) + dtime
		if self.timer > 1.5 then
			self.object:remove()
        end
    end
})

--Water bolt
core.register_entity("super_magic:water_bolt",{
        initial_properties = {
            physical = false,
            collide_with_objects = true,
            collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
            visual = "sprite",
            visual_size = {x=1,y=1,z=1},
            textures = {"super_magic_water_bolt.png"},
            spritediv = {x = 1, y = 1},
            initial_sprite_basepos = {x = 0, y = 0},
            glow = 14,
        },
       on_activate = function(self, staticdata)end,
        on_collision = function(self, other, point)
        self.object:remove()
	end,

    on_step = function(self, dtime)
        self.timer = (self.timer or 0) + dtime
		if self.timer > 2 then
			self.object:remove()
        end
        if self.timer > 1 then
			core.sound_play("super_magic_cast", {pos=self.object:get_pos(),gain=0.4,max_hear_distance=16})
        end
        local pos = self.object:get_pos()
        local node = core.get_node_or_nil(pos)
        if node and core.registered_nodes[node.name].walkable then
            core.set_node(pos, {name="default:water_source"})
        end

        for _,entity in pairs(core.get_objects_inside_radius(self.object:get_pos(),2)) do
            if entity:is_player() and entity:get_player_name() ~= self.owner then
                entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 5}},nil)
            end
            local luaentity = entity:get_luaentity()
            if luaentity and not self.removing then
                if luaentity.name ~= self.object:get_luaentity().name then
                    if entity:get_armor_groups().fleshy then
                        entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 5}},nil)
                    end
                end
            end
        end
        
        local pos = self.object:get_pos()
        if pos then
            core.add_particlespawner({
	    	    amount = 25,
	    	    time = 0.4,
	    	    minpos = pos,
	    	    maxpos = {x=pos.x,y=pos.y+1,z=pos.z},
	    	    minvel = {x=2.1, y=-2.1, z=2},
	    	    maxvel = {x=-2.1, y=2.1, z=-2.1},
	    	    minexptime = 0.2,
	    	    maxexptime = 0.3,
	    	    minsize = 1,
	    	    maxsize = 2.5,
	    	    collisiondetection = true,
	    	    texture = "super_magic_water_bolt_particle.png",
                glow = 12,
	        })
        end
		self.timer = (self.timer or 0) + dtime
		if self.timer > 1.5 then
			self.object:remove()
        end
    end
})

core.register_entity("super_magic:auto_water_bolt",{
        initial_properties = {
            physical = false,
            collide_with_objects = true,
            collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
            visual = "sprite",
            visual_size = {x=1,y=1,z=1},
            textures = {"super_magic_water_bolt.png"},
            spritediv = {x = 1, y = 1},
            initial_sprite_basepos = {x = 0, y = 0},
            glow = 14,
        },
       on_activate = function(self, staticdata)end,
        on_collision = function(self, other, point)
        self.object:remove()
	end,

    on_step = function(self, dtime)
        self.timer = (self.timer or 0) + dtime
		if self.timer > 2 then
			self.object:remove()
        end
        if self.timer > 1 then
			core.sound_play("super_magic_cast", {pos=self.object:get_pos(),gain=0.4,max_hear_distance=16})
        end
        local pos = self.object:get_pos()
        local node = core.get_node_or_nil(pos)
        if node and core.registered_nodes[node.name].walkable then
            core.set_node(pos, {name="default:water_source"})
        end

        for _,entity in pairs(core.get_objects_inside_radius(self.object:get_pos(),2)) do
            if entity:is_player() and entity:get_player_name() ~= self.owner then
                entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 2}},nil)
            end
            local luaentity = entity:get_luaentity()
            if luaentity and not self.removing then
                if luaentity.name ~= self.object:get_luaentity().name then
                    if entity:get_armor_groups().fleshy then
                        entity:punch(self.object,2.0,{full_punch_interval = 0.1,damage_groups = {fleshy = 2}},nil)
                    end
                end
            end
        end
        
        local pos = self.object:get_pos()
        if pos then
            core.add_particlespawner({
	    	    amount = 25,
	    	    time = 0.4,
	    	    minpos = pos,
	    	    maxpos = {x=pos.x,y=pos.y+1,z=pos.z},
	    	    minvel = {x=2.1, y=-2.1, z=2},
	    	    maxvel = {x=-2.1, y=2.1, z=-2.1},
	    	    minexptime = 0.2,
	    	    maxexptime = 0.3,
	    	    minsize = 1,
	    	    maxsize = 2.5,
	    	    collisiondetection = true,
	    	    texture = "super_magic_water_bolt_particle.png",
                glow = 12,
	        })
        end
		self.timer = (self.timer or 0) + dtime
		if self.timer > 1.5 then
			self.object:remove()
        end
    end
})