local S = core.get_translator("super_magic")

--Arcane
core.register_tool("super_magic:arcane_wand", {
    description = S("Arcane wand"),
    inventory_image = "super_magic_wand.png",
    on_use = function(itemstack,player,pointed_thing)
        local name = player:get_player_name()
        if mana.get(name) > 15 then
            core.sound_play("super_magic_cast", {gain=0.45,max_hear_distance=18})
            mana.subtract(name,15)
            local pos = player:get_pos()
            local dir = player:get_look_dir()
            local bolt = core.add_entity({x=pos.x,y=pos.y+1.25,z=pos.z}, "super_magic:arcane_bolt")
            bolt:setvelocity(dir:multiply(100))
            bolt:get_luaentity().owner = player:get_player_name()
        end
    end
})

--Fire
core.register_tool("super_magic:fire_wand", {
    description = S("Fire wand"),
    inventory_image = "super_magic_fire_wand.png",
    on_use = function(itemstack,player,pointed_thing)
        local name = player:get_player_name()
        if mana.get(name) > 20 then
            core.sound_play("super_magic_cast", {gain=0.50,max_hear_distance=20})
            mana.subtract(name,20)
            local pos = player:get_pos()
            local dir = player:get_look_dir()
            local bolt = core.add_entity({x=pos.x,y=pos.y+1.25,z=pos.z}, "super_magic:fire_bolt")
            bolt:setvelocity(dir:multiply(90))
            bolt:get_luaentity().owner = player:get_player_name()
        end
    end
})

--Air
core.register_tool("super_magic:air_wand", {
    description = S("Air wand"),
    inventory_image = "super_magic_air_wand.png",
    on_use = function(itemstack,player,pointed_thing)
        local name = player:get_player_name()
        if mana.get(name) > 5 then
            core.sound_play("super_magic_cast", {gain=0.25,max_hear_distance=8})
            mana.subtract(name,5)
            local pos = player:get_pos()
            local dir = player:get_look_dir()
            local bolt = core.add_entity({x=pos.x,y=pos.y+1.25,z=pos.z}, "super_magic:air_bolt")
            bolt:setvelocity(dir:multiply(90))
            bolt:get_luaentity().owner = player:get_player_name()
        end
    end
})

--Earth
core.register_tool("super_magic:earth_wand", {
    description = S("Earth wand"),
    inventory_image = "super_magic_earth_wand.png",
    on_use = function(itemstack,player,pointed_thing)
        local name = player:get_player_name()
        if mana.get(name) > 35 then
            core.sound_play("super_magic_cast", {gain=0.6,max_hear_distance=28})
            mana.subtract(name,35)
            local pos = player:get_pos()
            local dir = player:get_look_dir()
            local bolt = core.add_entity({x=pos.x,y=pos.y+1.25,z=pos.z}, "super_magic:earth_bolt")
            bolt:setvelocity(dir:multiply(150))
            bolt:get_luaentity().owner = player:get_player_name()
        end
    end
})

--Water
core.register_tool("super_magic:water_wand", {
    description = S("Water wand"),
    inventory_image = "super_magic_water_wand.png",
    on_use = function(itemstack,player,pointed_thing)
        local name = player:get_player_name()
        if mana.get(name) > 10 then
            core.sound_play("super_magic_cast", {gain=0.6,max_hear_distance=28})
            mana.subtract(name,10)
            local pos = player:get_pos()
            local dir = player:get_look_dir()
            local bolt = core.add_entity({x=pos.x,y=pos.y+1.25,z=pos.z}, "super_magic:water_bolt")
            bolt:setvelocity(dir:multiply(150))
            bolt:get_luaentity().owner = name
        end
    end
})

--Tomes
core.register_tool("super_magic:arcane_tome", {
    description = S("Arcane tome"),
    inventory_image = "super_magic_arcane_tome.png",
    on_use = function()end --Casting done through globalstep
})

core.register_tool("super_magic:fire_tome", {
    description = S("Fire tome"),
    inventory_image = "super_magic_fire_tome.png",
    on_use = function()end --Casting done through globalstep
})

core.register_tool("super_magic:air_tome", {
    description = S("Air tome"),
    inventory_image = "super_magic_air_tome.png",
    on_use = function()end --Casting done through globalstep
})

core.register_tool("super_magic:earth_tome", {
    description = S("Earth tome"),
    inventory_image = "super_magic_earth_tome.png",
    on_use = function()end --Casting done through globalstep
})

core.register_tool("super_magic:water_tome", {
    description = S("Water tome"),
    inventory_image = "super_magic_water_tome.png",
    on_use = function()end --Casting done through globalstep
})


--Casting auto
local timer = 0

core.register_globalstep(function(dtime)
    timer = timer + dtime
    if timer > 0.2 then
        for _,player in ipairs(core.get_connected_players()) do
            if player:get_wielded_item():get_name() == "super_magic:arcane_tome" and player:get_player_control().LMB then
                local name = player:get_player_name()
                if mana.get(name) > 5 then
                    core.sound_play("super_magic_cast", {gain=0.2,max_hear_distance=6})
                    mana.subtract(name,5)
                    local pos = player:get_pos()
                    local dir = player:get_look_dir()
                    local bolt = core.add_entity({x=pos.x,y=pos.y+1.25,z=pos.z}, "super_magic:auto_arcane_bolt")
                    bolt:setvelocity(dir:multiply(150))
                    bolt:get_luaentity().owner = name
                end
            elseif player:get_wielded_item():get_name() == "super_magic:fire_tome" and player:get_player_control().LMB then
                local name = player:get_player_name()
                if mana.get(name) > 7 then
                    core.sound_play("super_magic_cast", {gain=0.2,max_hear_distance=6})
                    mana.subtract(name,7)
                    local pos = player:get_pos()
                    local dir = player:get_look_dir()
                    local bolt = core.add_entity({x=pos.x,y=pos.y+1.25,z=pos.z}, "super_magic:auto_fire_bolt")
                    bolt:setvelocity(dir:multiply(150))
                    bolt:get_luaentity().owner = name
                end
            elseif player:get_wielded_item():get_name() == "super_magic:air_tome" and player:get_player_control().LMB then
                local name = player:get_player_name()
                if mana.get(name) > 2 then
                    core.sound_play("super_magic_cast", {gain=0.2,max_hear_distance=6})
                    mana.subtract(name,2)
                    local pos = player:get_pos()
                    local dir = player:get_look_dir()
                    local bolt = core.add_entity({x=pos.x,y=pos.y+1.25,z=pos.z}, "super_magic:air_bolt")
                    bolt:setvelocity(dir:multiply(150))
                    bolt:get_luaentity().owner = name
                end
            elseif player:get_wielded_item():get_name() == "super_magic:earth_tome" and player:get_player_control().LMB then
                local name = player:get_player_name()
                if mana.get(name) > 9 then
                    core.sound_play("super_magic_cast", {gain=0.2,max_hear_distance=6})
                    mana.subtract(name,9)
                    local pos = player:get_pos()
                    local dir = player:get_look_dir()
                    local bolt = core.add_entity({x=pos.x,y=pos.y+1.25,z=pos.z}, "super_magic:auto_earth_bolt")
                    bolt:setvelocity(dir:multiply(150))
                    bolt:get_luaentity().owner = name
                end
            elseif player:get_wielded_item():get_name() == "super_magic:water_tome" and player:get_player_control().LMB then
                local name = player:get_player_name()
                if mana.get(name) > 3 then
                    core.sound_play("super_magic_cast", {gain=0.2,max_hear_distance=6})
                    mana.subtract(name,3)
                    local pos = player:get_pos()
                    local dir = player:get_look_dir()
                    local bolt = core.add_entity({x=pos.x,y=pos.y+1.25,z=pos.z}, "super_magic:auto_water_bolt")
                    bolt:setvelocity(dir:multiply(150))
                    bolt:get_luaentity().owner = name
                end
            end
        end
        timer=0
    end
end)