# mtobjid

This library provides functions to obtain an ID for objects which is
persistent over subsequent unloading and loading of the objects, and
to operate on objects using the ID.

## setup

In order to use the functions on objects from another mod, this mod must
be loaded before the mod that registers the objects. This can be achieved
by defining `mtobjid` as an optional dependency of the other mod.

## usage

### get_id

Retrieve a persistent ID for a LuaEntity ObjectRef.

### get_object_by_id

Retrieve the corresponding ObjectRef using the ID obtained through
[get_id](#get_id). Returns nil if the object is currently unloaded.

### on_next_activation

Argument 1 (`objid`): ID obtained through [get_id](#get_id)

Argument 2 (`handler`): function accepting an ObjectRef

The next time the object corresponding to the ID `objid` is activated,
`handler` is called on the object.
