mtobjid = {
}

local get_new_id = (
    function(
    )
        local startup = os.time(
        )
        local last = 0
        return function(
        )
            last = last + 1
            return startup .. "." .. last
        end
    end
)(
)

local wrapped_entity_names = {
}

local known_objects = {
}

local activation_actions = {
}

local original_register_entity = minetest.register_entity

local original_add_entity = minetest.add_entity

minetest.register_entity = function(
    name,
    def
)
    def._mtobjid_on_step = def.on_step
    def._mtobjid_on_activate = def.on_activate
    def._mtobjid_on_deactivate = def.on_deactivate
    def._mtobjid_get_staticdata = def.get_staticdata
    def.on_step = function(
        self,
        dtime,
        moveresult
    )
        local last_state = {
        }
        last_state.last_pos = self.object:get_pos(
        )
        last_state.last_seen = os.time(
        )
        known_objects[
            self._mtobjid_id
        ] = last_state
        if self._mtobjid_on_step then
            return self._mtobjid_on_step(
                self,
                dtime,
                moveresult
            )
        end
    end
    def.on_activate = function(
        self,
        staticdata,
        dtime_s
    )
        local data = minetest.deserialize(
            staticdata
        )
        if not data then
            data = {
                original_staticdata = staticdata
            }
        end
        self._mtobjid_id = data.mtobjid_id
        if not self._mtobjid_id then
            data = {
                original_staticdata = staticdata
            }
            local new_id = get_new_id(
            )
            self._mtobjid_id = new_id
        end
        local result
	if self._mtobjid_on_activate then
            result = self._mtobjid_on_activate(
                self,
                data.original_staticdata,
                dtime_s
            )
        end
        local actions = activation_actions[
            self._mtobjid_id
        ]
        activation_actions[
            self._mtobjid_id
        ] = nil
        if actions then
            for _, action in pairs(
                actions
            ) do
                if action(
                    self.object
                ) then
                    break
                end
            end
        end
        return result
    end
    def.on_deactivate = function(
        self,
        removal
    )
        local operation
        if removal then
            known_objects[
                self._mtobjid_id
            ] = nil
        end
        if self._mtobjid_on_deactivate then
            return self._mtobjid_on_deactivate(
                self,
                removal
            )
        end
    end
    def.get_staticdata = function(
        self
    )
        local data = {
        }
        data.mtobjid_id = self._mtobjid_id
        if self._mtobjid_get_staticdata then
            data.original_staticdata = self._mtobjid_get_staticdata(
                self
            )
        end
        return minetest.serialize(
            data
        )
    end
    wrapped_entity_names[
        name
    ] = true
    return original_register_entity(
        name,
        def
    )
end

minetest.add_entity = function(
    pos,
    name,
    staticdata
)
    if wrapped_entity_names[
        name
    ] then
        local data = {
        }
        data.mtobjid_id = get_new_id(
        )
        data.original_staticdata = staticdata
        return original_add_entity(
            pos,
            name,
            minetest.serialize(
                data
            )
        )
    else
        return original_add_entity(
            pos,
            name,
            staticdata
        )
    end
end

local get_id = function(
    object
)
    return object._mtobjid_id
end

local get_object_by_id = function(
    objid
)
    local seen = known_objects[
        objid
    ]
    if not seen then
        return seen
    end
    local candidates = minetest.get_objects_inside_radius(
        seen.last_pos,
        5
    )
    for _, candidate in pairs(
        candidates
    ) do
        local entity = candidate:get_luaentity(
        )
        if entity and entity._mtobjid_id == objid then
            return candidate
        end
    end
end

local on_next_activation = function(
    objid,
    handler
)
    if not activation_actions[
        objid
    ] then
        activation_actions[
            objid
        ] = {
        }
    end
    activation_actions[
        objid
    ][
        #activation_actions[
            objid
        ] + 1
    ] = handler
end

mtobjid.get_id = get_id

mtobjid.get_object_by_id = get_object_by_id

mtobjid.on_next_activation = on_next_activation
