local modname = "voxeload"

local new_nodemap = function (
)
    local nodemap = {
        data = {
        },
    }
    nodemap.add = function (
        self,
        key,
        value
    )
        self.data[
            #self.data + 1
        ] = {
            key = key,
            value = value,
        }
    end
    nodemap.get_nearest = function (
        self,
        requested
    )
        local nearest_distance = math.huge
        local nearest_value
        for _, entry in pairs(
            self.data
        ) do
            local key = entry.key
            local value = entry.value
            local distance = (
                key.r - requested.r
            ) * (
                key.r - requested.r
            ) + (
                key.g - requested.g
            ) * (
                key.g - requested.g
            ) + (
                key.b - requested.b
            ) * (
                key.b - requested.b
            )
            if distance < nearest_distance then
                nearest_distance = distance
                nearest_value = value
            end
        end
        return nearest_value
    end
    return nodemap
end


local load_nodemap = function (
    filename
)
    local nodemap = new_nodemap(
    )
    local map_file = io.open(
        filename
    )
    if map_file then
        local data = map_file:read(
            "*all"
        )
        map_file:close(
        )
        for line in data:gmatch(
            "([^\n]*)\n?"
        ) do
            if not line:match(
                "^ *#"
            ) then
                local columns = {
                }
                for column in line:gmatch(
                    "[^ ]+"
                ) do
                    columns[
                        #columns + 1
                    ] = column
                end
                if columns[
                    4
                ] then
                    nodemap:add(
                        {
                            r = columns[
                                2
                            ],
                            g = columns[
                                3
                            ],
                            b = columns[
                                4
                            ],
                        },
                        minetest.get_content_id(
                            columns[
                                1
                            ]
                        )
                    )
                end
            end
        end
    end
    return nodemap
end

local new_voxelmap = function (
)
    local voxelmap = {
        data = {
        },
        min_x = math.huge,
        max_x = -math.huge,
        min_y = math.huge,
        max_y = -math.huge,
        min_z = math.huge,
        max_z = -math.huge,
    }
    voxelmap.get_min = function (
        self
    )
        return {
            x = self.min_x,
            y = self.min_y,
            z = self.min_z,
        }
    end
    voxelmap.get_max = function (
        self
    )
        return {
            x = self.max_x,
            y = self.max_y,
            z = self.max_z,
        }
    end
    voxelmap.add = function (
        self,
        x,
        y,
        z,
        value
    )
        if self.min_x > x then
            self.min_x = x
        end
        if self.min_y > y then
            self.min_y = y
        end
        if self.min_z > z then
            self.min_z = z
        end
        if self.max_x < x then
            self.max_x = x
        end
        if self.max_y < y then
            self.max_y = y
        end
        if self.max_z < z then
            self.max_z = z
        end
        if not self.data[
            x
        ] then
            self.data[
                x
            ] = {
            }
        end
        local plane = self.data[
            x
        ]
        if not plane[
            y
        ] then
            plane[
                y
            ] = {
            }
        end
        local line = plane[
            y
        ]
        line[
            z
        ] = value
    end
    return voxelmap
end

local load_voxelmap = function (
    nodemap,
    filename
)
    local voxelmap = new_voxelmap(
    )
    local voxel_file = io.open(
        filename
    )
    if voxel_file then
        local data = voxel_file:read(
            "*all"
        )
        voxel_file:close(
        )
        for line in data:gmatch(
            "([^\n]*)\n?"
        ) do
            local columns = {
            }
            for column in line:gmatch(
                "[^ ]+"
            ) do
                columns[
                    #columns + 1
                ] = column + 0
            end
            if columns[
                6
            ] then
                voxelmap:add(
                    columns[
                        1
                    ],
                    columns[
                        2
                    ],
                    columns[
                        3
                    ],
                    nodemap:get_nearest(
                        {
                            r = columns[
                                4
                            ],
                            g = columns[
                                5
                            ],
                            b = columns[
                                6
                            ],
                        }
                    )
                )
            end
        end
    end
    return voxelmap
end

minetest.register_chatcommand(
    "place_voxel",
    {
        params = "<nodemap> <voxelmap>",
        description = "Place a voxel object from file <voxelmap> with colors mapped to nodes as specified in the file <nodemap>",
        privs = {
            server = true,
        },
        func = function (
            player_name,
            param
        )
            local arguments = {
            }
            for argument in param:gmatch(
                "[^ ]+"
            ) do
                arguments[
                    #arguments + 1
                ] = argument
            end
            if 2 > #arguments then
                minetest.chat_send_player(
                    player_name,
                    "voxeload: too few parameters given"
                )
                return
            end
            if 2 < #arguments then
                minetest.chat_send_player(
                    player_name,
                    "voxeload: too many parameters given"
                )
                return
            end
            local nodemap = load_nodemap(
                minetest.get_modpath(
                    modname
                ) .. "/" .. arguments[
                    1
                ]
            )
            if not nodemap then
                minetest.chat_send_player(
                    player_name,
                    "voxeload: could not load nodemap from file " .. arguments[
                        1
                    ]
                )
                return
            end
            local voxelmap = load_voxelmap(
                nodemap,
                minetest.get_modpath(
                    modname
                ) .. "/" .. arguments[
                    2
                ]
            )
            if not voxelmap then
                minetest.chat_send_player(
                    player_name,
                    "voxeload: could not load voxels from file " .. arguments[
                        2
                    ]
                )
                return
            end
            local manipulator = minetest.get_voxel_manip(
            )
            if not manipulator then
                minetest.chat_send_player(
                    player_name,
                    "voxeload: could not initialize voxel manipulator"
                )
                return
            end
            local player = minetest.get_player_by_name(
                player_name
            )
            local base_pos = player:get_pos(
            )
            base_pos = {
                x = math.floor(
                    base_pos.x
                ),
                y = math.floor(
                    base_pos.y
                ),
                z = math.floor(
                    base_pos.z
                ),
            }
            local vmin = voxelmap:get_min(
            )
            local vmax = voxelmap:get_max(
            )
            local pmin, pmax = manipulator:read_from_map(
                vector.add(
                    base_pos,
                    vmin
                ),
                vector.add(
                    base_pos,
                    vmax
                )
            )
            local area = VoxelArea(
                pmin,
                pmax
            )
            local map_data = manipulator:get_data(
            )
            for x, plane in pairs(
                voxelmap.data
            ) do
                for y, line in pairs(
                    plane
                ) do
                    for z, value in pairs(
                        line
                    ) do
                        local pos = {
                            x = x,
                            y = y,
                            z = z,
                        }
                        local absolute = vector.add(
                            base_pos,
                            pos
                        )
                        map_data[
                            area:indexp(
                                absolute
                            )
                        ] = value
                    end
                end
            end
            manipulator:set_data(
                map_data
            )
            manipulator:calc_lighting(
            )
            manipulator:update_liquids(
            )
            manipulator:write_to_map(
            )
        end,
    }
)
