minetest.register_privilege("ban", {
    description = S("this permission serves to ban/unban players.")
})

minetest.register_chatcommand("perm_ban_ip", {
    params = S("[nickname] [reason]"),
    description = S("this command serves to ban the IP of a player by his nickname."),
    privs = {ban = true},
    func = function(name, param)
        local target, reason = param:match("^(%S+)%s*(.*)$")
        if not target then
            return false, S("usage : /perm_ban_ip [nickname] [reason]")
        end
        minetest.ban_player(target)
        return true, S("the player @1 has been successfully permanently banned.", target)
    end
})
