minetest.register_privilege("kick", {
    description = S("this permission serves to kick players.")
})

minetest.register_chatcommand("kick_nick", {
    params = S("[nickname] [reason]"),
    description = S("this command serves to kick a player by his nickname."),
    privs = {kick = true},
    func = function(name, param)
        local target, reason = param:match("^(%S+)%s*(.*)$")
        if not target then
            return false, S("usage : /kick_nick [nickname] [reason]")
        end
        local player = minetest.get_player_by_name(target)
        if not player then
            return false, S("the player @1 is not connected.", target)
        end
        local kick_message
        if reason and reason ~= "" then
            kick_message = S("you have been kicked from the game by titou punish for the reason « @1 ».", reason)
        else
            kick_message = S("you have been kicked from the game by titou punish.no reason was specified.")
        end
        minetest.kick_player(target, kick_message)
        return true, S("the player @1 has been successfully kicked.", target)
    end
})
