minetest.register_privilege("get_reports", {
    description = S("this permission serves to receive reports from players.")
})

minetest.register_chatcommand("report", {
    params = "[nickname] [reason]",
    description = S("this command serves to send a report to the game staff about a player who breaked the game rules."),
    func = function(name, param)
        if not param or param:len() == 0 then
            return false, S("usage : /report [nickname] [reason]")
        end
        local reported_player, reason = param:match("^%s*(%S+)%s*(.*)$")
        if not reason or reason:len() == 0 then
            return false, S("why do you want to report this player ? please say it to help the game staff.")
        end
        local report_message = S("@1 was reported by @2 for @3.", reported_player, name, reason)
        local recipients_found = false
        for _, player in ipairs(minetest.get_connected_players()) do
            local player_name = player:get_player_name()
            if minetest.check_player_privs(player_name, "get_reports") then
                minetest.chat_send_player(player_name, report_message)
                recipients_found = true
            end
        end
        if recipients_found then
            return true, S("your report about @1 has been successfully sent to a staff member.", reported_player)
        else
            return true, S("sorry but nobody able to manage reports is online.please try later.")
        end
    end,
})
