-- Copyright (c) 2024 Olivia May
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

-- The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
--
-- Simple mod that "glues" mods that modify the chat together.

local has_chat_anticurse = core.get_modpath("chat_anticurse")
local has_ranks = core.get_modpath("ranks")
local has_pronouns = core.get_modpath("pronouns")
local has_dcwebhook = core.get_modpath("dcwebhook")
local has_towny_chat = core.get_modpath("towny_chat")
--TODO: chat3

-- Copied from ranks mod
-- [local function] Get colour
local function get_colour(colour)
	if type(colour) == "table" and core.rgba then
		return core.rgba(colour.r, colour.g, colour.b, colour.a)
	elseif type(colour) == "string" then
		return colour
	else
		return "#ffffff"
	end
end
--

local func = function(name, message)
	if has_chat_anticurse then
		if chat_anticurse.is_curse_found(name, message) then
			return true
		end
	end

	local chat_name = name

	local ranks_prefix = ""
	local ranks_uncolored_prefix = ""
	if has_ranks then
		local rank = ranks.get_rank(name)

		if rank then
			local def = ranks.get_def(rank)
			if def.prefix then

				local colour = get_colour(def.colour)
				ranks_uncolored_prefix = def.prefix
				local prefix = core.colorize(colour, def.prefix)
				if def.babybox then
					message = ranks.babybox(message)
				end
				-- no awkward spaces if we don't have the ranks mod
				ranks_uncolored_prefix = ranks_uncolored_prefix .. " "
				ranks_prefix = prefix .. " "
			end
		end
	end

	local pronouns_str = ""
	if has_pronouns then
		local pronouns_list = pronouns.get(name)
		local i = 0

		if #pronouns_list > 0 then
			pronouns_str = "("
			for i = 1, #pronouns_list - 1 do
				pronouns_str = pronouns_str .. pronouns_list[i] .."/"
			end
			pronouns_str =
				pronouns_str .. pronouns_list[#pronouns_list] .. ") "
		end
	end

	local towny_chat_str = ""
	if has_towny_chat then
		local res = towny.residents[name]
		if towny.chat.channels[name] == towny.chat.CHANNEL_GLOBAL then
			if res.town then
				towny_chat_str = "[" .. res.town.name .. "]"
			end
			chat_name = res:get_display_name()
		else
			return towny.chat.chat_message_func(name, message)
		end
		towny_chat_str = towny_chat_str .. " "
	end

	core.chat_send_all(
		ranks_prefix .. towny_chat_str .. "<" .. chat_name .. "> " .. pronouns_str .. message)

	if has_dcwebhook then
		local wrapped_name = core.settings:get("dcwebhook.name_wrapper") or "<**@1**>"
		wrapped_name = wrapped_name:gsub("@(.)", chat_name)

		dcwebhook.send_webhook({
			content = ranks_uncolored_prefix .. towny_chat_str .. wrapped_name .. " " .. pronouns_str .. message
		})
	end

	return true
end

-- this might be buggy in the future. insert at `2` otherwise commands
-- won't work
table.insert(core.registered_on_chat_messages, 2, func)
