-- LUALOCALS < ---------------------------------------------------------
local core, pairs, piredo_api, piredo_map, piredo_player,
      piredo_schems, string, vector
    = core, pairs, piredo_api, piredo_map, piredo_player,
      piredo_schems, string, vector
local string_sub
    = string.sub
-- LUALOCALS > ---------------------------------------------------------

local modname = core.get_current_modname()

-- Get the shared API table
local api = piredo_api.get_mod_api()

-- Send location checks for puzzle solves
do
	local old = piredo_player.discover
	piredo_player.discover = function(label, cb, ...)
		-- Ignore discoveries other than actual puzzle solves.
		if not piredo_api.starts_with(label, "solve:") then
			return old(label, cb, ...)
		end
		local checkname = string_sub(label, #"solve:" + 1)

		-- Deal with the final goal.
		if checkname == "final_warp" then
			api.sendgoal()
			api.manager:goal_complete()
		end

		-- Look for a location matching the puzzle.
		local state = api.manager.state
		if state and state.slot_data and state.slot_data.locations then
			for _, metadata in pairs(state.slot_data.locations) do
				if metadata.piredo_solve == checkname then
					api.sendcheck(metadata.id)
					return old(label, nil, ...)
				end
			end
		end
		
		return old(label, cb, ...)
	end
end

-- Handle room entry
do
	local old = piredo_map.set_current_room
	function piredo_map.set_current_room(roompos, room, ...)
		local state = api.manager.state

		-- Send "room entry" check
		if state and state.slot_data and state.slot_data.locations then
			for _, metadata in pairs(state.slot_data.locations) do
				if metadata.piredo_entry == room then
					api.sendcheck(metadata.id)
				end
			end
		end

		-- Search for locations to replace within the room
		local checked = api.alreadychecked(state)
		piredo_map.override_schematic_nodes(function()
				local state = api.manager.state
				if state and state.slot_data and state.slot_data.locations then
					for _, metadata in pairs(state.slot_data.locations) do
						if metadata.piredo_schematic == room
						and metadata.piredo_x
						and metadata.piredo_y
						and metadata.piredo_z then
							local pos = vector.offset(roompos,
								metadata.piredo_x,
								metadata.piredo_y,
								metadata.piredo_z)
							local schem = piredo_schems[room]
							if schem and schem.pos then
								pos = vector.add(pos, schem.pos)
							end

							-- Replace with placeholder if unchecked, air if checked
							if checked[metadata.id] then
								core.remove_node(pos)
							else
								core.set_node(pos, {name = modname .. ":apitem"})
								core.get_meta(pos):set_float(modname, metadata.id)
							end
						end
					end
				end
			end)

		return old(roompos, room, ...)
	end
end
