local selfcare_timers = {}

local random = math.random
local tn = tonumber
local ts = tostring

selfcare.s_t = tonumber(minetest.settings:get("selfcare.smell_timer")) or 1800
selfcare.h_t = tonumber(minetest.settings:get("selfcare.hair_timer")) or 2400
selfcare.c_t = tonumber(minetest.settings:get("selfcare.condish_timer")) or 3600
selfcare.t_t = tonumber(minetest.settings:get("selfcare.teeth_timer")) or 126000
selfcare.b_t = tonumber(minetest.settings:get("selfcare.breath_timer")) or 1200
selfcare.fs_t = tonumber(minetest.settings:get("selfcare.skin_timer")) or 2400
selfcare._fs_t = tonumber(minetest.settings:get("selfcare.dryness_timer")) or 2700
selfcare.p_t = tonumber(minetest.settings:get("selfcare.pimples_timer")) or 3600
selfcare.pp_t = tonumber(minetest.settings:get("selfcare.pimpatch_timer")) or 1800
selfcare.pf_t = tonumber(minetest.settings:get("selfcare.perfume_timer")) or 2400


minetest.register_globalstep(function(dtime)
    for _, player in ipairs(minetest.get_connected_players()) do
	local n = player:get_player_name()

    if selfcare.get(player, "selfcare") then

	    if not selfcare_timers[n] then
		selfcare_timers[n] = {
		   s_t = tn(selfcare.get(player, "smell_t")) or 0,
		   h_t = tn(selfcare.get(player, "hair_t")) or 0,
		   c_t = tn(selfcare.get(player, "condish_t")) or 0,
		   t_t = tn(selfcare.get(player, "teeth_t")) or 0,
		   b_t = tn(selfcare.get(player, "breath_t")) or 0,
		   p_t = tn(selfcare.get(player, "pimples_t")) or 0,
		   pp_t = tn(selfcare.get(player, "pimpatch_t")) or 0,
		   fs_t = tn(selfcare.get(player, "faceskin_t")) or 0,
		   _fs_t = tn(selfcare.get(player, "_faceskin_t")) or 0,
		   pf_t = tn(selfcare.get(player, "perfume_t")) or 0
		}
	    end

	for timer, time in pairs(selfcare_timers[n]) do
	    selfcare_timers[n][timer] = selfcare_timers[n][timer] + dtime
	end


--		[ individual timers ]

    if selfcare_timers[n].s_t >= selfcare.s_t then
	 local smell = selfcare.get(player, "smell")
	if smell == "clean" then
	   selfcare.set(player, "smell", "neutral")
	elseif smell == "neutral" then
	   selfcare.set(player, "smell", "bad")
	   selfcare.send(n, "I stink!")
	end
	selfcare_timers[n].s_t = 0
    end

    if selfcare_timers[n].h_t >= selfcare.h_t then
	 local hair = selfcare.get(player, "hair")
	if hair == "clean" then
	   selfcare.set(player, "hair", "dirty")
	   selfcare.send(n, "I should wash my hair now..")
	end
	selfcare_timers[n].h_t = 0
    end

    if selfcare_timers[n].c_t >= selfcare.c_t then
	 local condish = selfcare.get(player, "condish")
	if condish == "soft" then
	   selfcare.set(player, "condish", "dry")
	elseif condish == "dry" then
	   selfcare.set(player, "condish", "dehydrated")
	end
	selfcare_timers[n].c_t = 0
    end

    if selfcare_timers[n].t_t >= selfcare.t_t then
	 local teeth = selfcare.get(player, "teeth")
	if teeth == "white" then
	   selfcare.set(player, "teeth", "ivory")
	elseif teeth == "ivory" then
	   selfcare.set(player, "teeth", "cream")
	elseif teeth == "cream" then
	   selfcare.set(player, "teeth", "slightly yellow")
	   selfcare.send(n, "Uhh my teeth look weird-")
	elseif teeth == "slightly yellow" then
	   selfcare.set(player, "teeth", "yellow")
	   selfcare.send(n, "My teeth look so gross!")
	end
	selfcare_timers[n].t_t = 0
    end

    if selfcare_timers[n].b_t >= selfcare.b_t then
	 local breath = selfcare.get(player, "breath")
	if breath == "minty" then
	   selfcare.set(player, "breath", "neutral")
	elseif breath == "fresh" then
	   selfcare.set(player, "breath", "neutral")
	elseif breath == "neutral" then
	   selfcare.set(player, "breath", "slightly bad")
	elseif breath == "slightly bad" then
	   selfcare.set(player, "breath", "bad")
	   selfcare.send(n, "I need to brush my teeth")
	elseif breath == "bad" then
	   selfcare.set(player, "breath", "disgusting")
	   selfcare.send(n, "Ew my breath could kill")
	end
	selfcare_timers[n].b_t = 0
    end

    if selfcare_timers[n].fs_t >= selfcare.fs_t then
	 local faceskin = selfcare.get(player, "faceskin")
	if faceskin == "clean" then
	   selfcare.set(player, "faceskin", "dirty")
	elseif faceskin == "dirty" and math.random(1,11) < 5 then
	   selfcare.set(player, "faceskin", "clogged")
	   selfcare.set(player, "_faceskin", "oily")
	   selfcare.send(n, "Is my skin clogged?")
	end
	selfcare_timers[n].fs_t = 0
    end

    if selfcare_timers[n]._fs_t >= selfcare._fs_t then
	 local _faceskin = selfcare.get(player, "_faceskin")
	if _faceskin == "soft" then
	   selfcare.set(player, "_faceskin", "dry")
	end
	selfcare_timers[n]._fs_t = 0
    end

    if selfcare_timers[n].p_t >= selfcare.p_t then
	 local faceskin = selfcare.get(player, "faceskin")
	if faceskin == "clogged" then
	  local pimple_num = tn(selfcare.get(player, "pimples")) + 1
	    if pimple_num > 6 then pimple_num = 6
	       selfcare.send(n, "My face hurts")
	    end
	   selfcare.set(player, "pimples", ts(pimple_num))
	end
	selfcare_timers[n].p_t = 0
    end

    if selfcare_timers[n].pp_t >= selfcare.pp_t then
	 local pimpatch = selfcare.get(player, "pimpatch")
	if pimpatch == "yes" then
	  local pimples = tn(selfcare.get(player, "pimples")) - 1
	    if pimples < 0 then pimples = 0 end
	   selfcare.set(player, "pimples", ts(pimples))
	   selfcare.set(player, "pimpatch", "no")
	end
	selfcare_timers[n].pp_t = 0
    end

    if selfcare_timers[n].pf_t >= selfcare.pf_t then
	 local perfume = selfcare.get(player, "perfume")
	if perfume == "are" then
	   selfcare.set(player, "perfume", "aren't")
	end
	selfcare_timers[n].pf_t = 0
    end


--		[ memorize timers ]

	selfcare.set(player, "s_t", ts(selfcare_timers[n].s_t))
	selfcare.set(player, "h_t", ts(selfcare_timers[n].h_t))
	selfcare.set(player, "c_t", ts(selfcare_timers[n].c_t))
	selfcare.set(player, "t_t", ts(selfcare_timers[n].t_t))
	selfcare.set(player, "b_t", ts(selfcare_timers[n].b_t))
	selfcare.set(player, "fs_t", ts(selfcare_timers[n].fs_t))
	selfcare.set(player, "_fs_t", ts(selfcare_timers[n]._fs_t))
	selfcare.set(player, "p_t", ts(selfcare_timers[n].p_t))
	selfcare.set(player, "pp_t", ts(selfcare_timers[n].pp_t))
	selfcare.set(player, "pf_t", ts(selfcare_timers[n].pf_t))

	end
    end
end)