local function player_pos(name)
  return core.get_player_by_name(name):get_pos()
end
local function _1_(itemstack, user, pointed_thing)
  for i, player in ipairs(core.get_connected_players()) do
    print(player)
  end
  return nil
end
core.register_craftitem("brainbeam:players", {description = "players", on_use = _1_})
local function _2_(itemstack, user, pointed_thing)
  local rc = core.raycast((user:get_pos() + (user:get_look_dir() * 2)), (user:get_pos() + (user:get_look_dir() * 100)))
  for pointed_thing0 in rc do
    local case_3_ = pointed_thing0.type
    if (case_3_ == "object") then
      if not pointed_thing0.ref:get_attach() then
        pointed_thing0.ref:right_click(user)
      else
      end
    else
    end
  end
  return nil
end
core.register_craftitem("brainbeam:beamer", {description = "beamer", inventory_image = "beam.png", on_use = _2_})
local function _6_(itemstack, user, pointed_thing)
  return fennel.dofile("player.fnl")
end
core.register_craftitem("brainbeam:reload", {description = "reload", on_use = _6_})
local function _7_(name, param)
  return fennel.dofile("repl.fnl")
end
core.register_chatcommand("rl", {description = "reload sorta repl", func = _7_})
local player_guid = nil
local birdbud_guid = nil
local function get_player()
  if player_guid then
    return core.objects_by_guid[player_guid]
  else
    player_guid = core.get_player_by_name("singleplayer"):get_guid()
    return core.objects_by_guid[player_guid]
  end
end
local function get_birdbud()
  if birdbud_guid then
    return core.objects_by_guid[birdbud_guid]
  else
    for _, ent in pairs(core.luaentities) do
      if (ent.name == "brainbeam:birdbud") then
        birdbud_guid = ent.object:get_guid()
      else
      end
    end
    return core.objects_by_guid[birdbud_guid]
  end
end
local function get_waypoint1()
  local waypoint = nil
  for _, ent in pairs(core.luaentities) do
    if waypoint then break end
    if ((ent.name == "brainbeam:waypoint1") and ent.object:is_valid()) then
      waypoint = ent.object
    else
      waypoint = nil
    end
  end
  return waypoint
end
local function avg_list_vecs(vecs)
  local _12_
  do
    local sum_vecs = vector.zero()
    for _, vec in ipairs(vecs) do
      sum_vecs = (sum_vecs + vec)
    end
    _12_ = sum_vecs
  end
  return (_12_ / #vecs)
end
local function all_of(list, member, predicate)
  if not list then
    return false
  else
    local check = true
    for _, v in ipairs(list) do
      if (check == false) then break end
      if not predicate(v[member]) then
        check = false
      else
      end
    end
    return check
  end
end
local function on_ground_3f(obj)
  local pos_below = (obj:get_pos() - vector.new(0, 0.5, 0))
  return (core.get_node(pos_below).name ~= "air")
end
local function colliding(v1, v2)
  return ((math.abs((v1.x - v2.x)) < 1) and (math.abs((v1.y - v2.y)) < 1) and (math.abs((v1.z - v2.z)) < 1))
end
local function exp_decay(v)
  local base = 2
  local max = 4
  local k = 0
  return (base + ((max - base) * math.exp(( - (k * (v / base))))))
end
local function get_ent_spawn_pos(ent)
  local player = get_player()
  local meta = player:get_meta()
  return ent._spawn_pos[meta:get_string("brainbeam_level")]
end
local function get_level()
  local player = get_player()
  local meta = player:get_meta()
  return meta:get_string("brainbeam_level")
end
local function restart_level()
  local player = get_player()
  local meta = player:get_meta()
  local level = meta:get_string("brainbeam_level")
  local center = ({level1 = vector.new(30, 30, 30), level2 = vector.new(230, 30, 230)})[level]
  local blockers = core.find_nodes_in_area((center - vector.new(60, 60, 60)), (center + vector.new(60, 60, 60)), "brainbeam:emerald_blocker")
  local crafts = core.find_nodes_in_area((center - vector.new(60, 60, 60)), (center + vector.new(60, 60, 60)), "brainbeam:crafter_main")
  local air = core.find_nodes_in_area((center - vector.new(60, 60, 60)), (center + vector.new(60, 60, 60)), "brainbeam:air")
  for _, obj in ipairs(player:get_children()) do
    obj:set_detach()
  end
  for _, b in ipairs(blockers) do
    core.remove_node(b)
    core.set_node(b, {name = "brainbeam:emerald_detect"})
  end
  for _, a in ipairs(air) do
    core.remove_node(a)
    core.set_node(a, {name = "brainbeam:amethyst_solid"})
  end
  for _, c in ipairs(crafts) do
    core.remove_node(c)
  end
  for _, ent in pairs(core.luaentities) do
    if ent._spawn_pos then
      ent.object:set_pos(get_ent_spawn_pos(ent))
    else
    end
    if ent._look_dir then
      ent.object:set_yaw(ent._look_dir)
    else
    end
    local case_17_ = ent.name
    if (case_17_ == "brainbeam:crafter") then
      ent._blocks = 5
    elseif (case_17_ == "brainbeam:parkourist") then
      ent._reset_pos = nil
    elseif (case_17_ == "brainbeam:brainbeacon") then
      ent.object:right_click(get_player())
    else
    end
  end
  return nil
end
local function _19_(itemstack, user, pointed_thing)
  return restart_level()
end
core.register_craftitem("brainbeam:restart", {description = "restart level", inventory_image = "restart.png", on_use = _19_})
local function parkour_gstep(pkent, dtime, moveresult)
  local pkobj = pkent.object
  local player = get_player()
  local pos = player:get_pos()
  local minp = (pos - vector.new(0.6, 0, 0.6))
  local maxp = (pos + vector.new(0.6, 0, 0.6))
  local vel = player:get_velocity()
  local gravity = player:get_physics_override().gravity
  local on_ground = on_ground_3f(player)
  local control = player:get_player_control()
  local run_nodes = core.find_nodes_in_area(minp, maxp, "brainbeam:wallrun", true)
  local bird_nearby = colliding(pos, get_birdbud():get_pos())
  local run_node = next(run_nodes)
  if bird_nearby then
    if (vel.y < 0) then
      player:add_velocity(vector.new(0, ( - vel.y), 0))
    else
    end
    player:add_velocity(vector.new(0, 1, 0))
  else
  end
  if (control.jump and not pkent._wallrunning) then
    pkent._can_jump = false
  else
  end
  if (not pkent._wallrunning and run_node and not on_ground and (vel.y < 3)) then
    pkent._wallrunning = true
    player:set_physics_override({gravity = 0.2})
  else
  end
  if (not pkent._can_jump and (on_ground or pkent._wallrunning) and not control.jump) then
    pkent._can_jump = true
  else
  end
  if ((on_ground or not run_node) and pkent._wallrunning) then
    pkent._wallrunning = false
    player:set_physics_override({gravity = 1})
  else
  end
  if (control.jump and pkent._can_jump and pkent._wallrunning) then
    pkent._can_jump = false
    local node_posl = run_nodes[run_node]
    local avg_node_pos = avg_list_vecs(node_posl)
    local diffx = (pos.x - avg_node_pos.x)
    local diffz = (pos.z - avg_node_pos.z)
    if (math.abs(diffx) > 0.5) then
      return player:add_velocity(vector.new((diffx * 10), 6, 0))
    else
      return player:add_velocity(vector.new(0, 6, (diffz * 10)))
    end
  else
    return nil
  end
end
local new_level = nil
local function common_gstep(ent)
  local player = get_player()
  local node_at = core.get_node(player:get_pos())
  if string.match(node_at.name, "_source") then
    if not new_level then
      new_level = get_level()
    elseif (new_level ~= get_level()) then
      new_level = get_level()
      restart_level()
    elseif ent._reset_pos then
      player:set_pos(ent._reset_pos)
    else
      player:set_pos(get_ent_spawn_pos(ent))
    end
  else
  end
  if (ent.object:get_animation().x ~= player:get_animation().x) then
    return ent.object:set_animation(player:get_animation())
  else
    return nil
  end
end
local function become_crafter(player, ent)
  player:set_physics_override({speed = 1, jump = 1, sneak = true})
  local inv = player:get_inventory()
  inv:set_size("main", 4)
  return inv:set_list("main", {ItemStack(("brainbeam:crafter_main " .. ent._blocks)), ItemStack(), ItemStack("brainbeam:beamer"), ItemStack("brainbeam:restart")})
end
local function become_parkourist(player, ent)
  player:set_physics_override({speed = 1.4, jump = 1.2, sneak = true})
  local inv = player:get_inventory()
  inv:set_size("main", 6)
  return inv:set_list("main", {ItemStack("brainbeam:parkour_main"), ItemStack(), ItemStack("brainbeam:beamer"), ItemStack("brainbeam:restart")})
end
local function become_whisperer(player, ent)
  player:set_physics_override({speed = 1, jump = 0, sneak = false})
  local inv = player:get_inventory()
  inv:set_size("main", 6)
  return inv:set_list("main", {ItemStack("brainbeam:whisperer_main"), ItemStack(), ItemStack("brainbeam:beamer"), ItemStack("brainbeam:restart")})
end
local function become_beacon(player, ent)
  player:set_physics_override({speed = 0, jump = 0, sneak = false})
  local inv = player:get_inventory()
  inv:set_size("main", 2)
  return inv:set_list("main", {ItemStack("brainbeam:beamer"), ItemStack("brainbeam:restart")})
end
local function beamed_player(player, ent)
  player:add_velocity(( - player:get_velocity()))
  do
    local case_31_ = ent.name
    if (case_31_ == "brainbeam:parkourist") then
      become_parkourist(player, ent)
    elseif (case_31_ == "brainbeam:whisperer") then
      become_whisperer(player, ent)
    elseif (case_31_ == "brainbeam:crafter") then
      become_crafter(player, ent)
    elseif (case_31_ == "brainbeam:brainbeacon") then
      become_beacon(player, ent)
    else
    end
  end
  ent._is_player = true
  for _, attached in ipairs(player:get_children()) do
    attached:set_detach()
    attached:set_pos(attached:get_pos())
  end
  local ento = ent.object
  player:set_physics_override({gravity = 1})
  player:set_pos(ento:get_pos())
  return ento:set_attach(player)
end
local function _33_(self, player)
  return beamed_player(player, self)
end
local function _34_(self, dtime, moveresult)
  if self._is_player then
    return common_gstep(self)
  else
    return nil
  end
end
local function _36_(self, player)
  self._is_player = false
  return nil
end
core.register_entity("brainbeam:crafter", {initial_properties = {visual = "mesh", mesh = "character.b3d", textures = {"character_4.png"}, visual_size = {x = 1, y = 1}}, on_rightclick = _33_, on_step = _34_, on_detach = _36_, _look_dir = 3.1, _spawn_pos = {level1 = vector.new(20, 27.5, 38), level2 = vector.new(242, 26.5, 250)}, _blocks = 5, _is_player = false})
local function _37_(self, player)
  return beamed_player(player, self)
end
local function _38_(self, dtime, moveresult)
  if self._is_player then
    common_gstep(self)
    return parkour_gstep(self, dtime, moveresult)
  else
    return nil
  end
end
local function _40_(self, player)
  self._is_player = false
  return nil
end
core.register_entity("brainbeam:parkourist", {initial_properties = {visual = "mesh", mesh = "character.b3d", textures = {"character_8.png"}, visual_size = {x = 1, y = 1}, physical = true, collide_with_objects = true}, on_rightclick = _37_, on_step = _38_, on_detach = _40_, _look_dir = 5.6, _spawn_pos = {level1 = vector.new(16, 27.5, 27), level2 = vector.new(242, 26.5, 246)}, _reset_pos = nil, _can_jump = true, _is_player = false, _wallrunning = false})
local function move_bird(birdobj)
  local birdbud = birdobj.object
  local bent = birdbud:get_luaentity()
  local bpos = birdbud:get_pos()
  local bvel = birdbud:get_velocity()
  local waypoint1 = get_waypoint1()
  if waypoint1 then
    local dir = (vector.direction(bpos, waypoint1:get_pos()) * 3)
    return birdbud:set_velocity(vector.new(dir.x, bvel.y, dir.z))
  else
    return birdbud:set_velocity(vector.zero())
  end
end
local function _42_(self, _staticdata, _dtime_s)
  return self.object:set_animation({x = 0, y = 95}, 15)
end
local function _43_(self, _dtime, _moveresult)
  if self._moving then
    return move_bird(self)
  elseif (self.object:get_velocity() ~= vector.zero()) then
    return self.object:set_velocity(vector.zero())
  else
    return nil
  end
end
core.register_entity("brainbeam:birdbud", {initial_properties = {visual = "mesh", mesh = "animal_gull.b3d", textures = {"animal_gull_mesh.png"}, automatic_face_movement_dir = 0.0, physical = true, backface_culling = false, collide_with_objects = false}, on_activate = _42_, on_step = _43_, _look_dir = 0.55, _spawn_pos = {level1 = vector.new(29, 28.5, 23), level2 = vector.new(247, 29, 245)}, _moving = false})
local function clear_waypoints()
  for _, ent in pairs(core.luaentities) do
    if string.find(ent.name, "waypoint") then
      ent.object:remove()
    else
    end
  end
  return nil
end
local function whisperer_gstep(wsent, dtime)
  local wsobj = wsent.object
  local player = get_player()
  local pos = wsobj:get_pos()
  local eyepos = (player:get_pos() + vector.new(0, player:get_properties().eye_height, 0))
  local vel = wsobj:get_velocity()
  local control = player:get_player_control()
  local birdbud = get_birdbud()
  local bvel = birdbud:get_velocity()
  if control.jump then
    return birdbud:set_velocity(vector.new(bvel.x, 1, bvel.z))
  elseif control.sneak then
    return birdbud:set_velocity(vector.new(bvel.x, -1, bvel.z))
  elseif control.aux1 then
    return clear_waypoints()
  else
    return birdbud:set_velocity(vector.new(bvel.x, 0, bvel.z))
  end
end
local function entity_active_3f(ent_name)
  local exists = false
  for _, ent in pairs(core.luaentities) do
    if exists then break end
    exists = (ent.name == ent_name)
  end
  return exists
end
local function place_waypoint(_, player, _0)
  do
    local eyepos = (player:get_pos() + vector.new(0, player:get_properties().eye_height, 0))
    local rc = core.raycast(eyepos, (eyepos + (player:get_look_dir() * 100)), false)
    local pointed_pos = (rc:next().under + vector.new(0, 1, 0))
    if entity_active_3f("brainbeam:waypoint3") then
    elseif entity_active_3f("brainbeam:waypoint2") then
      core.add_entity(pointed_pos, "brainbeam:waypoint3")
    elseif entity_active_3f("brainbeam:waypoint1") then
      core.add_entity(pointed_pos, "brainbeam:waypoint2")
    else
      core.add_entity(pointed_pos, "brainbeam:waypoint1")
    end
  end
  return nil
end
local function set_bird_off()
  local birdbud = get_birdbud()
  local bent = birdbud:get_luaentity()
  if bent._moving then
    bent._moving = false
    return nil
  else
    bent._moving = true
    return nil
  end
end
core.register_craftitem("brainbeam:whisperer_main", {description = "whisperer main tool for waypoint setting and setting off", inventory_image = "butterflies_butterfly_white.png", on_place = set_bird_off, on_secondary_use = set_bird_off, on_use = place_waypoint})
local function spawner_particles(pos)
  return core.add_particlespawner({amount = 32, time = 0, pos = {min = (pos - vector.new(-0.4, -0.4, -0.4)), max = (pos + vector.new(0.4, 0.4, 0.4))}, vel = {min = vector.new(-0.4, -0.4, -0.4), max = vector.new(0.4, 0.4, 0.4)}, texture = "amethyst_particle.png"})
end
local function _49_(_, player, _0)
  local _1, pkobj = next(player:get_children())
  local pkent = pkobj:get_luaentity()
  if on_ground_3f(player) then
    if pkent._spawner then
      core.delete_particlespawner(pkent._spawner)
    else
    end
    pkent._spawner = spawner_particles(player:get_pos())
    pkent._reset_pos = player:get_pos()
    return nil
  else
    return nil
  end
end
core.register_craftitem("brainbeam:parkour_main", {description = "parkourist main tool for saving pos", inventory_image = "butterflies_butterfly_white.png", on_use = _49_})
local function above_or_below(v1, v2)
  return ((math.abs((v1.x - v2.x)) < 0.5) and (math.abs((v1.z - v2.z)) < 0.5))
end
local function _52_(self, _dtime, _moveresult)
  local birdbud = get_birdbud()
  if above_or_below(self.object:get_pos(), birdbud:get_pos()) then
    return self.object:remove()
  else
    return nil
  end
end
core.register_entity("brainbeam:waypoint1", {initial_properties = {visual = "sprite", textures = {"waypoint1.png"}}, on_step = _52_})
local function _54_(self, _dtime, _moveresult)
  if not entity_active_3f("brainbeam:waypoint1") then
    core.add_entity(self.object:get_pos(), "brainbeam:waypoint1")
    return self.object:remove()
  else
    return nil
  end
end
core.register_entity("brainbeam:waypoint2", {initial_properties = {visual = "sprite", textures = {"waypoint2.png"}}, on_step = _54_})
local function _56_(self, _dtime, _moveresult)
  if not entity_active_3f("brainbeam:waypoint2") then
    core.add_entity(self.object:get_pos(), "brainbeam:waypoint2")
    return self.object:remove()
  else
    return nil
  end
end
core.register_entity("brainbeam:waypoint3", {initial_properties = {visual = "sprite", textures = {"waypoint3.png"}}, on_step = _56_})
local function _58_(self, player)
  return beamed_player(player, self)
end
local function _59_(self, dtime, moveresult)
  if self._is_player then
    common_gstep(self)
    return whisperer_gstep(self, dtime)
  else
    return nil
  end
end
local function _61_(self, player)
  self._is_player = false
  return nil
end
core.register_entity("brainbeam:whisperer", {initial_properties = {visual = "mesh", mesh = "character.b3d", textures = {"character_11.png"}, visual_size = {x = 1, y = 1}}, on_rightclick = _58_, on_step = _59_, on_detach = _61_, _look_dir = 0.55, _spawn_pos = {level1 = vector.new(24, 27.5, 26), level2 = vector.new(245, 26.5, 245)}, _is_player = false})
core.register_node("brainbeam:lime_torch", {description = "brain torch", drawtype = "mesh", mesh = "torch_floor.obj", tiles = {{name = "lime_torch_animated.png", animation = {type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 3.3}}}, use_texture_alpha = "clip", paramtype = "light", paramtype2 = "wallmounted", sunlight_propagates = true, walkable = false})
local function _62_(self, player)
  return beamed_player(player, self)
end
local function _63_(self, player)
  self._is_player = false
  return nil
end
core.register_entity("brainbeam:brainbeacon", {initial_properties = {visual = "node", visual_size = {x = 1, y = 2}, node = {name = "brainbeam:lime_torch", param2 = 1}, collide_with_objects = true, collisionbox = {-1, -2, -1, 1, 2, 1}, selectionbox = {-1, -2, -1, 1, 2, 1}}, on_rightclick = _62_, on_detach = _63_, _spawn_pos = {level1 = vector.new(20, 29, 33), level2 = vector.new(250, 31.5, 253)}, _is_player = false})
local function _64_(name, param)
  return core.add_entity(player_pos(name), "brainbeam:birdbud")
end
core.register_chatcommand("birdbud", {description = "spawn bird", func = _64_})
local function _65_(name, param)
  return core.add_entity(player_pos(name), "brainbeam:crafter")
end
core.register_chatcommand("crafter", {description = "spawn some guy", func = _65_})
local function _66_(name, param)
  return core.add_entity(player_pos(name), "brainbeam:parkourist")
end
core.register_chatcommand("parkourist", {description = "spawn some guy", func = _66_})
local function _67_(name, param)
  return core.add_entity(player_pos(name), "brainbeam:whisperer")
end
core.register_chatcommand("whisperer", {description = "spawn some guy", func = _67_})
local function _68_(name, param)
  return core.add_entity(player_pos(name), "brainbeam:brainbeacon")
end
core.register_chatcommand("beacon", {description = "spawn some guy", func = _68_})
local function _69_(name, param)
  local objs = core.objects_inside_radius(player_pos(name), 100)
  for obj in objs do
    if obj:get_attach() then
      obj:set_detach()
    else
    end
  end
  return nil
end
core.register_chatcommand("detachall", {description = "no more attached", func = _69_})
local function _71_(name, param)
  local player = core.get_player_by_name(name)
  return player:set_properties({is_visible = false})
end
core.register_chatcommand("setinvis", {description = "set invis", func = _71_})
local function _72_(player, last_login)
  do
    local formspec = ("formspec_version[6]" .. "size[10,8]" .. "label[0.5,0.5;=== Characters ===]" .. "textarea[0.5,1;9,6.5;;;" .. "Parkourist (guy with glasses) - Jumps high, runs on ruby glass walls, and bounces off bird. Main tool can save position.\n" .. "Crafter (diamond guy) - Sets blocks... pretty dope if you ask me\n" .. "Bird whisperer (regular dude) - Talks to bird. Main tool sets waypoints on use and starts/stops bird on place. Jump and sneak raise and lower. Aux1 removes waypoints (use this often).\n" .. "]" .. "label[0.5,3;=== Goal ===]" .. "textarea[0.5,3.5;9,6.5;;;" .. "Touch sparkles!\n" .. "]")
    player:set_inventory_formspec(formspec)
  end
  player:hud_set_hotbar_itemcount(16)
  player:hud_set_hotbar_image("blank.png")
  return player:set_properties({textures = {"blank.png"}})
end
core.register_on_joinplayer(_72_)
local function build_levels()
  do
    local player = get_player()
    local meta = player:get_meta()
    meta:set_string("brainbeam_level", "level1")
  end
  core.place_schematic(vector.new(1, 1, 1), (core.get_modpath("brainbeam") .. "/schems/level1.mts"))
  core.place_schematic(vector.new(200, 1, 200), (core.get_modpath("brainbeam") .. "/schems/level2.mts"))
  core.add_entity(vector.new(1, 1, 1), "brainbeam:parkourist")
  core.add_entity(vector.new(1, 1, 1), "brainbeam:whisperer")
  core.add_entity(vector.new(1, 1, 1), "brainbeam:crafter")
  core.add_entity(vector.new(1, 1, 1), "brainbeam:birdbud")
  core.add_entity(vector.new(1, 1, 1), "brainbeam:brainbeacon")
  return restart_level()
end
local function sparkles()
  do
    local blockers = core.find_nodes_in_area(vector.new(1, 1, 1), vector.new(300, 100, 300), "brainbeam:emerald_detect")
    for _, b in ipairs(blockers) do
      core.set_node(b, {name = "brainbeam:emerald_detect"})
    end
  end
  do
    local finish = core.find_nodes_in_area(vector.new(1, 1, 1), vector.new(300, 100, 300), "brainbeam:finish")
    for _, s in ipairs(finish) do
      core.set_node(s, {name = "brainbeam:finish"})
    end
  end
  local breaker = core.find_nodes_in_area(vector.new(1, 1, 1), vector.new(300, 100, 300), "brainbeam:break_amethyst")
  for _, a in ipairs(breaker) do
    core.set_node(a, {name = "brainbeam:break_amethyst"})
  end
  return nil
end
core.after(3, sparkles)
local function _73_()
  new_level = get_level()
  return nil
end
core.after(4, _73_)
core.register_on_newplayer(build_levels)
local function _74_()
  return core.override_item("", {range = 10})
end
core.register_on_mods_loaded(_74_)
local function _75_(name, param)
  return core.clear_objects()
end
return core.register_chatcommand("clearall", {description = "remove all entities", func = _75_})
