local function register_undiggable_node(name, desc) --for nodes that can't be broken
   core.register_node('ls_map:'..name, {
      description = desc,
      tiles = {{name='ls_map_'..name..'.png', align_style='world', scale=4}},
      inventory_image = '[inventorycube{ls_map_'..name..'.png&[sheet:4x4:1,1{ls_map_'..name..'.png&[sheet:4x4:1,1{ls_map_'..name..'.png&[sheet:4x4:1,1',
   --   sounds = {footstep = {name = sound, gain = vol}}
      groups = {stone=1, level=2}
   })
end

register_undiggable_node('stone', 'Stone')

local function register_diggable_nodes(name, desc, item, group)
   local group1 = table.copy(group)
   group1.dig=4
   local group2 = table.copy(group)
   group2.dig=3
   local group3 = table.copy(group)
   group3.dig=2
   local group4 = table.copy(group)
   group4.dig=1

   core.register_node('ls_map:'..name..'_4', {
      description = desc,
      tiles = {{name='ls_map_'..name..'.png', align_style='world', scale=4}},
      node_dig_prediction = 'ls_map:'..name..'_3',
      groups = group4,
      _level = 4,
      drop = '',
      after_dig_node = function(pos, oldnode, oldmetadata, digger)
         local tool = digger:get_wielded_item()
         local tool_name = tool:get_name()
         if core.get_item_group(tool_name, 'shovel') > 0 then
            core.remove_node(pos)
            ls_map.add_inv(digger, 'ls_map:'..name..'_4')
         else
            local above = vector.add(pos, {x=0,y=1,z=0})
            local above_node = core.get_node(above)
            local def = core.registered_items[above_node.name]
            if def then
               if def.buildable_to or not def.walkable then
                  core.swap_node(pos, {name = 'ls_map:'..name..'_3'})
                  ls_map.add_inv(digger, item)
               else
                  core.swap_node(pos, {name = 'ls_map:'..name..'_4'})
               end
            end
         end
      end,
   })

   core.register_node('ls_map:'..name..'_3', {
      description = desc..' (3/4 Node)',
      drawtype = 'nodebox',
      node_box = {
         type = 'fixed',
         fixed = {
            {-0.5, -0.5, -0.5, 0.5, 0.25, 0.5}},
         },
      paramtype = 'light',
      tiles = {{name='ls_map_'..name..'.png', align_style='world', scale=4}},
      groups = group3,
      _level = 3,
      drop = '',
      node_dig_prediction = 'ls_map:'..name..'_2',
      after_dig_node = function(pos, oldnode, oldmetadata, digger)
         local tool = digger:get_wielded_item()
         local tool_name = tool:get_name()
         if core.get_item_group(tool_name, 'shovel') > 0 then
            core.remove_node(pos)
            ls_map.add_inv(digger, item..' 1')
            ls_map.add_inv(digger, 'ls_map:'..name..'_2')
         else
            core.swap_node(pos, {name = 'ls_map:'..name..'_2'})
            ls_map.add_inv(digger, item)
         end
      end,
   })

   core.register_node('ls_map:'..name..'_2', {
      description = desc..' (1/2 Node)',
      drawtype = 'nodebox',
      node_box = {
         type = 'fixed',
         fixed = {
            {-0.5, -0.5, -0.5, 0.5, 0, 0.5}},
         },
      paramtype = 'light',
      tiles = {{name='ls_map_'..name..'.png', align_style='world', scale=4}},
      groups = group2,
      _level = 2,
      drop = '',
      node_dig_prediction = 'ls_map:'..name..'_1',
      after_dig_node = function(pos, oldnode, oldmetadata, digger)
         local tool = digger:get_wielded_item()
         local tool_name = tool:get_name()
         if core.get_item_group(tool_name, 'shovel') > 0 then
            core.remove_node(pos)
            ls_map.add_inv(digger, 'ls_map:'..name..'_2')
         else
            core.swap_node(pos, {name = 'ls_map:'..name..'_1'})
            ls_map.add_inv(digger, item)
         end
      end,
   })

   core.register_node('ls_map:'..name..'_1', {
      description = desc..' (1/4 Node)',
      drawtype = 'nodebox',
      node_box = {
         type = 'fixed',
         fixed = {
            {-0.5, -0.5, -0.5, 0.5, -0.25, 0.5}},
         },
      paramtype = 'light',
      tiles = {{name='ls_map_'..name..'.png', align_style='world', scale=4}},
      groups = group1,
      _level = 1,
      drop = '',
      after_dig_node = function(pos, oldnode, oldmetadata, digger)
         local tool = digger:get_wielded_item()
         local tool_name = tool:get_name()
         if core.get_item_group(tool_name, 'shovel') > 0 then
            core.remove_node(pos)
            ls_map.add_inv(digger, item..' 1')
         else
            core.remove_node(pos)
            ls_map.add_inv(digger, item)
         end
      end,
   })
end

register_diggable_nodes('dirt', 'Dirt', 'ls_items:dirt', {dirt=1, breakable=4})
register_diggable_nodes('gravel', 'Gravel', 'ls_items:gravel', {gravel=1, breakable=4})
