local S = core.get_translator("cow_menu")
local F = core.formspec_escape

local PLAY_TIME = 120

cow_menu = {}

-- Returns formspec string for allow_close.
local allow_close = function(player)
	if core.is_creative_enabled(player:get_player_name()) then
		-- We allow closing formspec in creative formspec for convenience
		return "allow_close[true]"
	else
		return "allow_close[false]"
	end
end

cow_menu.open_menu = function(player, update_state)
	if update_state ~= false then
		cow_objects.remove_all_level_objects()
		player:set_camera({mode="third"})
		cow_game.stop_play(player)
		cow_game.set_state(cow_game.STATE_MENU)

		local level_num = cow_levels.get_level_by_name("menu_lab")
		cow_levels.init_level(level_num)
		cow_levels.go_to_level(player, level_num)
		cow_player.set_texture_mode(player, "normal")
	end
	local form = "formspec_version[9]" ..
		"size[8,7.5]"..
		allow_close(player)..
		"set_focus[start;false]"..
		"style[start;fgimg_hovered=cow_menu_play_hover.png;fgimg_pressed=cow_menu_play_pressed.png]"..
		"style[help;fgimg_hovered=cow_menu_help_hover.png;fgimg_pressed=cow_menu_help_pressed.png]"..
		"style[exit;fgimg_hovered=cow_menu_exit_hover.png;fgimg_pressed=cow_menu_exit_pressed.png]"..
		"style_type[image;noclip=true]"..
		"image[1.28572,-2.25;5.42856,2;cow_menu_header.png]"..
		"image_button[2,1;4,1.50778;cow_menu_play.png;start;]"..
		"image_button[2,3;4,1.50778;cow_menu_help.png;help;]"..
		"image_button[2,5;4,1.50778;cow_menu_exit.png;exit;]"

	core.show_formspec(player:get_player_name(), "cow_menu:menu", form)
end

local help_hypertext =
"<tag name=_cow_hl color=#e3c054>"..
"<tag name=_cow_angry color=#e3c054>"..
"<style color=#ebecdc>"..
S([==[<bigger>Help</bigger>
<_cow_hl><b>C.O.W.</b></_cow_hl> is a a top secret military experiment with the goal to turn ordinary farm animals into weapons: the <_cow_hl><b>Cows of War</b></_cow_hl>.

But one brave cow managed to breach containment. That cow is <i>you</i>. You want <b>revenge</b>!

<big>Goal</big>
Use your deadly <_cow_hl><b>laser eyes</b></_cow_hl> and your <_cow_hl><b>super jump</b></_cow_hl> ability to destroy everything that moves.
The more you destroy, the better your score.

You have 3 lives. If you get hit, you lose a life.
The game ends when the time runs out or you’ve lost all lives.

<big>Controls</big>
<_cow_hl><b>Look</b></_cow_hl> at enemies to hit them with laser beams.
Use the <_cow_hl><b>movement keys</b></_cow_hl> to move.
Hold down <_cow_hl><b>Aux1</b></_cow_hl> and press movement key to boost in that direction.
If you’re stuck on the floor, press the <_cow_hl><b>jump key</b></_cow_hl> to jump.]==])..
"</style>"

core.register_on_player_receive_fields(function(player, formname, fields)
	if formname == "cow_menu:menu" then
		if fields.start then
			core.close_formspec(player:get_player_name(), formname)
			local level_num = cow_levels.get_level_by_name("town")
			cow_game.start_play(player, { time = PLAY_TIME, level = level_num })
		elseif fields.help then
			local form = "formspec_version[9]" ..
			"size[11,10.5]"..
			allow_close(player)..
			"box[0.4,0.4;10.2,8.7;#1e7453ff]"..
			"hypertext[0.5,0.5;10,8.5;help_hypertext;"..core.hypertext_escape(help_hypertext).."]"..
			"style[back;fgimg_hovered=cow_menu_back_hover.png;fgimg_pressed=cow_menu_back_pressed.png]"..
			"image_button[0.5,9.35;2,0.75389;cow_menu_back.png;back;]"
			core.show_formspec(player:get_player_name(), "cow_menu:help", form)
		elseif fields.exit then
			core.request_shutdown()
			core.show_formspec(player:get_player_name(), "cow_menu:shutdown",
				"formspec_version[9]"..
				"size[6,2]"..
				allow_close(player)..
				"label[1,1;"..F(S("Shutting down …")).."]")
		end
	elseif formname == "cow_menu:help" then
		if fields.back then
			cow_menu.open_menu(player, false)
		end
	end
end)

core.register_on_joinplayer(function(player)
	if core.is_creative_enabled(player:get_player_name()) then
		return
	end
	cow_menu.open_menu(player, true)
end)

