local S = minetest.get_translator("lzr_pack_forgotten_treasures")

local pack_title = S("Forgotten Treasures")
local min_version = "2.1.0"

-- Compatibility test for game version 2.1.0
if not core.registered_nodes["lzr_doors:trapdoor_wood_locked_flat_fixed"] then -- this node was introduced in Lazarr! 2.1.0
	minetest.log("action", "[lzr_pack_forgotten_treasures] Lazarr! version is too old for this level pack. The level pack has not been added. Game version 2.1.0 or later is required.")
	core.register_on_joinplayer(function(player)
		core.chat_send_player(player:get_player_name(),
			core.colorize("#FF0000",
				S("FAILURE: Your Lazarr! version is too old for the level pack “@1”. It has been disabled. Please update to Lazarr! version @2 (or later) and try again.",
					pack_title,
					min_version))
			)
	end)
end

-- Register level pack

lzr_levels.register_level_pack("forgotten_treasures",
	{
		title = pack_title,
		description = S("Official community level pack"),
		textdomain_npc_texts = "lzr_pack_forgotten_treasures_npc_texts",
		textdomain_level_names = "lzr_pack_forgotten_treasures_level_names",
	}
)
