
local vm_data = {}

local c_stone = minetest.get_content_id("artifact:stone")
local c_chest = minetest.get_content_id("chest_with_everything:chest")

minetest.register_on_generated(function(vm, minp, maxp)
    local min, max = vm:get_emerged_area()
    local va = VoxelArea(min, max)
    
    vm:get_data(vm_data)
    
    if maxp.y < 0 then
        for i in va:iterp(minp, maxp) do
            vm_data[i] = c_stone
        end
    elseif maxp.y < 50 then
        for x = min.x, max.x do
            for z = min.z, max.z do
                for y = min.y, -1 do
                    vm_data[va:index(x, y, z)] = c_stone
                end
                if x == 0 and z == 2 then
                    vm_data[va:index(x, 0, z)] = c_chest
                end
            end
        end
    end
    
    vm:set_data(vm_data)
    minetest.generate_decorations(vm)
    vm:calc_lighting()
end)
