-- Copyright (C) 2025 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

-- This is a wrapper for any value that implements the 


local ExpressionWrapper = 
{
	instance_of = "LanguageConstruct_ExpressionWrapper",
	static = true,
}

ExpressionWrapper.__index = ExpressionWrapper

-- slight difference from usual constructors. Directly pass the value instead of wrapping it in a table
function ExpressionWrapper:new(v)
	self = setmetatable({value = v}, ExpressionWrapper)

	return self
end

function ExpressionWrapper:evaluate(ctx)
	return self.value
end

function ExpressionWrapper:static_eval()
	return self.value
end

function ExpressionWrapper:parse()
	error("You can't parse an ExpressionWrapper")
end

function ExpressionWrapper:dump(dump_ctx)
	local prefix = dump_ctx:color("(ExpressionWrapper) ", "ConstructSpecifier")
	dump_ctx:write_line(string.format("%s%s", prefix, self.value))
end

return ExpressionWrapper
