-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

--- @classmod LanguageConstruct_SingleQuoteString
--	Describes a string enclodes in single quotes, which is a literal string that supports no escape sequences

local SingleQuoteString =
{
	instance_of = "LanguageConstruct_SingleQuoteString",
	static = true,
}

SingleQuoteString.__index = SingleQuoteString

function SingleQuoteString:new(t)
	if not t then
		t = {}
	end

	self = setmetatable(
	{
		text = t.text or ""
	}, SingleQuoteString)

	return self
end

---@diagnostic disable-next-line: unused-local
function SingleQuoteString:evaluate(ctx)
	-- {{{ type checking
	assert(type(self.text) == "string", "self.text should be of type string. instead of " .. type(self.text))
	-- }}}

	return self.text
end

function SingleQuoteString:static_eval()
	return self.text
end

function SingleQuoteString:parse(parser_ctx)
	-- {{{ type checking
	assert(parser_ctx.instance_of == "ParserContext", "parser_ctx should be an instance of ParserContext. instead of " .. parser_ctx.instance_of)
	-- }}}

	parser_ctx:advance()

	-- state: '*

	local start_character_index = parser_ctx.character_index

	parser_ctx:skip_until(
	{
		["'"] = true
	})

	self.text = string.sub(parser_ctx.text, start_character_index, parser_ctx.character_index - 1)

	-- state: '<text>*

	parser_ctx:advance()

	-- state: '<text>'*

end

function SingleQuoteString:dump(dump_ctx)
	local prefix = dump_ctx:color("(SingleQuoteString) ", "ConstructSpecifier")
	dump_ctx:write_text(string.format([[%s"%s"]], prefix, dump_ctx:color(self.text, "String")))
end

return SingleQuoteString
