-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

--- @classmod LanguageConstruct_StringExpression
--	Acts as an abstraction for DoubleQuoteString, SingleQuoteString and UnquotedString language constructs

local DoubleQuoteString
local SingleQuoteString
local UnquotedString

local StringExpression =
{
	instance_of = "LanguageConstruct_StringExpression",
}

StringExpression.__index = StringExpression

function StringExpression:new()
	return setmetatable({}, StringExpression)
end

function StringExpression:parse(parser_ctx, terminators)
	local first_char = parser_ctx:peek()

	local expression
	if first_char == "\"" then
		DoubleQuoteString = DoubleQuoteString or require("language_constructs.double_quote_string")
		expression = DoubleQuoteString:new()
		expression:parse(parser_ctx)
	elseif first_char == "'" then
		SingleQuoteString = SingleQuoteString or require("language_constructs.single_quote_string")
		expression = SingleQuoteString:new()
		expression:parse(parser_ctx)
	else
		UnquotedString = UnquotedString or require("language_constructs.unquoted_string")
		expression = UnquotedString:new()
		expression:parse(parser_ctx, terminators)
	end

	for key, value in pairs(expression) do
		self[key] = value
	end

	setmetatable(self, getmetatable(expression))
end

return StringExpression
