-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

-- this is a reimplementation of typed list thats optimized for outputting text to chat
-- this is considerably faster because it dosent store all the lines before writing them

---@diagnostic disable: redundant-return, unused-local

local DatatypeValidator = require("datatype_validator")

local ChatOutput =
{
	instance_of = "TypedList"
}

ChatOutput.__index = ChatOutput

--- constructor
--  @tab t table with matching keys as the class, with initialization values for the members
--  @treturn ChatOutput|nil the newly created Command instance
function ChatOutput:new(player_name)
	local t = {}

	self = setmetatable(
	{
		-- leaving these here in case something assumes these are defined
		container = t.container or {},
		type = "string"
	}, ChatOutput)
	self.player_name = player_name

	return self
end

function ChatOutput:__len()
	return #self.container
end

--- adds a new element to the end of the list
--	@param value element to add
--	@treturn nil
function ChatOutput:push(value, ctx)
	-- {{{ type checking
	-- if not DatatypeValidator.is_valid_type(value) then error("trying to append an invalid datatype") end
	-- }}}
	core.chat_send_player(self.player_name, DatatypeValidator.cast_to(value, "string", ctx))
end

--- removes the last element
--	@return the last element
function ChatOutput:pop()
	return
end

--- get element at the given index
--	@number index
--	@return element
function ChatOutput:get(index)
	-- {{{ type checking
		assert(type(index) == "number", "index should be of type number. instead of " .. type(index))
	-- }}}

	return
end

--- set element at the given index
--	@number index
--	@param value
--	@treturn nil
function ChatOutput:set(index, value, ctx)
	-- {{{ type checking
	assert(type(index) == "number", "index should be of type number. instead of " .. type(index))
	-- if not DatatypeValidator.is_valid_type(value) then error("trying to set an element with an invalid datatype") end
	-- }}}

	return
end

function ChatOutput:clear()
	return
end

function ChatOutput:concat(t)
	-- {{{ type checking
	assert(type(t) == "table", "t should be of type table. instead of " .. type(t))
	-- }}}

	if t.instance_of == "TypedList" then
		t = t.container
	end

	if #t == 0 then
		return
	end

	for _, v in pairs(t) do
		self:push(v)
	end
end

function ChatOutput:cast_to(datatype, ctx)
	return datatype == "string"
end

function ChatOutput:printout()
	return
end

function ChatOutput:iterator()
	error("you cant iterate over the chat output")
end

return ChatOutput
