-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

---@diagnostic disable: duplicate-set-field

local helpers = require("helpers")

--- Deals damage; copied from better_commands.deal_damage() :)
--- which in turn is copied from Mineclonia's mcl_util.deal_damage
--	@ObjectRef target
--	@number damage
--	@tab reason
--	@bool damage_immortal
--	@treturn nil
function helpers.deal_damage(target, damage, reason, damage_immortal)
	local luaentity = target:get_luaentity()

	if luaentity then
		if luaentity.deal_damage then -- Mobs Redo/Mobs MC
			luaentity:deal_damage(damage, reason or {type = "generic"})
			return
        elseif luaentity.hurt then -- Animalia
            luaentity:hurt(damage)
            luaentity:indicate_damage()
            return
        elseif luaentity.health then -- Mobs Redo/Mobs MC/NSSM
			if luaentity.health > 0 then
				luaentity.health = luaentity.health - damage
				luaentity:check_for_death(reason)
			end
			return
		end
	end

	local hp = target:get_hp()
	local armorgroups = target:get_armor_groups()

	if hp > 0 and armorgroups and (damage_immortal or not armorgroups.immortal) then
		target:set_hp(hp - damage, reason)
	end
end
-- this function originates from worldedit
local function strip_escapes(input)
	local s = function(idx) return input:sub(idx, idx) end
	local out = ""
	local i = 1
	while i <= #input do
		if s(i) == "\027" then -- escape sequence
			i = i + 1
			if s(i) == "(" then -- enclosed
				i = i + 1
				while i <= #input and s(i) ~= ")" do
					if s(i) == "\\" then
						i = i + 2
					else
						i = i + 1
					end
				end
			end
		else
			out = out .. s(i)
		end
		i = i + 1
	end
	--print(("%q -> %q"):format(input, out))
	return out
end

-- table cache of descriptions for fast lookup
-- key - node description
-- value - technical nodename
local node_description_cache = nil

-- normalizes node "description" `nodename`, returning a string (or nil)
-- this function originates from worldedit
function helpers.normalize_nodename(nodename)
	nodename = strip_escapes(nodename):trim()

	if nodename == "" then return nil end

	local fullname = core.registered_aliases[nodename] -- resolve aliases
	if core.registered_nodes[fullname] or fullname == "air" then -- full name
		return fullname
	end

	nodename = string.lower(nodename)

	-- if matches the technical name but without the mod suffix
	if core.registered_nodes[nodename:find("^.*:(.*)$")] then
		return nodename("^.*:(.*)$")
	end

	if node_description_cache == nil then
		-- cache stripped descriptions
		node_description_cache = {}
		for key, value in pairs(core.registered_nodes) do
			local desc = strip_escapes(value.description):match("^%s*([^\n]+)")
			if desc and desc ~= "" then
				desc = string.lower(desc)
				node_description_cache[desc] = key
			end
		end
	end

	-- if matches description
	if node_description_cache[nodename] then
		return node_description_cache[nodename]
	end
end

function helpers.print(value)
	core.debug(dump(value))
end

return helpers
