-- Copyright (C) 2024 rstcxk
-- 
-- This program is free software: you can redistribute it and/or modify it under the terms of
-- the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
-- without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 

local InventoryItemList =
{
	instance_of = "InventoryItemList"
}

InventoryItemList.__index = InventoryItemList

function InventoryItemList:new(t)
	self = setmetatable(
	{
		location = t.location or {},
		indexes = t.indexes or {}
	},
	InventoryItemList)

	return self
end

function InventoryItemList:get_lists()
	local output_table = {}
	local inv = core.get_inventory(self.location)

	if not inv then
		return {}
	end

	for listname, indexes in pairs(self.indexes) do
		output_table[listname] = {}
		for _, index in pairs(indexes) do
			table.insert(output_table[listname], inv:get_stack(listname, index))
		end
	end

	return output_table
end

function InventoryItemList:set_lists(list)
	local inv = core.get_inventory(self.location)
	local inv_table = inv:get_lists()

	local i = 1
	for listname, indexes in pairs(self.indexes) do
		for _, index in pairs(indexes) do
			inv_table[listname][index] = list[listname][i]
			i = i + 1
		end
	end

	inv:set_lists(inv_table)
end

function InventoryItemList:get_length()
	local count = 0
	for _, indexes in pairs(self.indexes) do
		for _, _ in pairs(indexes) do
			count = count + 1
		end
	end

	 return count
end

return InventoryItemList
