local S = core.get_translator(core.get_current_modname());

-- PIES
for i, filling in pairs({"apple", "pumpkin", "sweet_berry"}) do

    -- MAKE PIE
    core.register_craftitem("craftoplus:raw_pie_"..filling, {
        description = S("Raw "..craftoplus.to_name(filling, 1).." Pie"),
        _tt_help = S("You need to bake it before eat."),
        wield_image = "pie_"..filling..".png^dough_crust_form_mask.png",
        inventory_image = "pie_"..filling..".png^dough_crust_form_mask.png",
        groups = { craftitem = 1, },
        stack_max = 16,
    })
    
    if (i == 1) then -- Apple Pie
        core.register_craft({
            output = "craftoplus:raw_pie_"..filling,
            recipe = {
                {"mcl_core:apple", "mcl_core:apple", "mcl_core:apple"},
                {"mcl_core:apple", "mcl_core:apple", "mcl_core:apple"},
                {"mcl_core:sugar", "craftoplus:dough_crust_form", "mcl_core:sugar"},
            }
        })
    elseif (i == 2) then -- Pumpkin Pie
        core.register_craft({
            output = "craftoplus:raw_pie_"..filling,
            recipe = {
                {"mcl_throwing:egg", "mcl_farming:pumpkin", "mcl_throwing:egg"},
                {"mcl_core:sugar", "craftoplus:dough_crust_form", "mcl_core:sugar"},
            }
        })
    elseif (i == 3) then -- Sweet Berry
        core.register_craft({
            output = "craftoplus:raw_pie_"..filling,
            recipe = {
                {"mcl_farming:sweet_berry", "mcl_farming:sweet_berry", "mcl_farming:sweet_berry"},
                {"mcl_farming:sweet_berry", "mcl_farming:sweet_berry", "mcl_farming:sweet_berry"},
                {"mcl_core:sugar", "craftoplus:dough_crust_form", "mcl_core:sugar"},
            }
        })
    end
        
    -- -------------------------
    
    -- BAKE PIE
    core.register_craftitem("craftoplus:pie_"..filling, {
        description = S(craftoplus.to_name(filling, 1).." Pie"),
        inventory_image = "pie_"..filling..".png",
        wield_image = "pie_"..filling..".png",
        on_place = core.item_eat(7),
        on_secondary_use = core.item_eat(7),
        groups = {food = 2, eatable = 7, compostability = 85},
        _mcl_saturation = 5.2,
        stack_max = 16,
    })

    core.register_craft({
        type = "cooking",
        recipe = "craftoplus:raw_pie_"..filling,
        output = "craftoplus:pie_"..filling,
        cooktime = 15
    })
    
    -- -------------------------
    
    -- PIE PIECE
    local pie_piece = "craftoplus:pie_"..filling.."_piece";
    
    if (i == 2) then -- Pumpkin Pie
        core.clear_craft({
            type = "shapeless",
            output = "mcl_farming:pumpkin_pie",
            recipe = {"mcl_farming:pumpkin", "mcl_core:sugar", "mcl_throwing:egg"},
        });
        
        pie_piece = "mcl_farming:pumpkin_pie";
    end
    
    local pie_data = {
        description = S(craftoplus.to_name(filling, 1).." Pie Piece"),
        _doc_items_longdesc = S("A "..filling.." pie is a tasty food item which can be eaten."),
        inventory_image = "pie_"..filling.."_piece.png",
        wield_image = "pie_"..filling.."_piece.png",
        on_place = core.item_eat(2),
        on_secondary_use = core.item_eat(2),
        groups = {food = 2, eatable = 2, compostability = 100},
        _mcl_saturation = 1.4,
    };
    
    if (i == 2) then -- Pumpkin Pie
        core.override_item(pie_piece, pie_data);
    else
        core.register_craftitem(pie_piece, pie_data);
    end
    
    core.register_craft({
        type = "shapeless",
        output = pie_piece.." 4",
        recipe = {"craftoplus:pie_"..filling},
    });
    
    core.register_craft({
        output = "craftoplus:pie_"..filling,
        recipe = {
            {pie_piece, pie_piece},
            {pie_piece, pie_piece},
        },
    });
    
end