local S = core.get_translator(core.get_current_modname());
local modpath = core.get_modpath(core.get_current_modname());
local random, floor = math.random, math.floor;

-- APPLE TREE
mcl_trees.register_wood("apple",{
    readable_name = "Apple",
    sign_color="#A1765D",
    tree_schems= {
        { file = modpath.."/schematics/apple_tree_1.mts"},
        { file = modpath.."/schematics/apple_tree_2.mts"},
        { file = modpath.."/schematics/apple_tree_3.mts"},
        { file = modpath.."/schematics/apple_tree_4.mts"},
    },
    tree = { tiles = {"apple_tree_top.png", "apple_tree_top.png","apple_tree.png"} },
    leaves = {
        tiles = { "apple_leaves.png" },
        color = "#FFFFFF",
    },
    drop_apples = true,
    wood = { tiles = {"apple_wood.png"}},
    sapling = {
        tiles = {"apple_sapling.png"},
        inventory_image = "apple_sapling.png",
        wield_image = "apple_sapling.png",
        _after_grow=mcl_trees.sapling_add_bee_nest,
    },
    door = {
        inventory_image = "apple_door.png",
        tiles_bottom = {"apple_door_lower.png", "apple_door_side_lower.png"},
        tiles_top = {"apple_door_upper.png", "apple_door_side_upper.png"}
    },
    trapdoor = {
        tile_front = "apple_trapdoor.png",
        tile_side = "apple_trapdoor_side.png",
        wield_image = "apple_trapdoor.png",
    },
    potted_sapling = {
        image = "apple_sapling.png",
    },
})

-- APPLE FRUIT LEAF
local apple_leaves_def = core.registered_nodes["mcl_trees:leaves_apple"];

core.register_node("craftoplus:leaves_with_fruit_apple", {
    description = apple_leaves_def["description"],
    _doc_items_longdesc = apple_leaves_def["_doc_items_longdesc"],
    tiles = {"apple_leaves.png", "default_apple.png"},
    drawtype = "mesh",
    mesh = "apple_leaf.obj",
    paramtype = apple_leaves_def["paramtype"],
    paramtype2 = apple_leaves_def["paramtype2"],
    waving = apple_leaves_def["waving"],
    groups = apple_leaves_def["groups"],
    palette = apple_leaves_def["palette"],
    after_place_node = apple_leaves_def["after_place_node"],
    _mcl_leaves = apple_leaves_def["_mcl_leaves"],
    _mcl_orphan_leaves = apple_leaves_def["_mcl_orphan_leaves"],
    sounds = apple_leaves_def["sounds"],
        
    drop = "mcl_core:apple",
    on_rightclick = function(pos, _, clicker, itemstack)
        core.add_item(pos, "mcl_core:apple");
        core.swap_node(pos, {name = "mcl_trees:leaves_apple"});
    end,
        
    on_construct = apple_leaves_def["on_construct"],
    after_destruct = apple_leaves_def["after_destruct"],
        
    _doc_items_create_entry = apple_leaves_def["_doc_items_create_entry"],
    _mcl_shears_drop = apple_leaves_def["_mcl_shears_drop"],
    _mcl_silk_touch_drop = apple_leaves_def["_mcl_silk_touch_drop"],
});

-- ABM
core.register_abm({
    label = "Bring Fruits",
    nodenames = {"mcl_trees:leaves_apple"},
    interval = random(15, 100),
    chance = 5,
    action = function(pos, node)
        local tree_exist = core.find_node_near(pos, 3, "mcl_trees:tree_apple");
        local fruit_exist = core.find_node_near(pos, 1, "craftoplus:leaves_with_fruit_apple");
        if (tree_exist ~= nil) and (fruit_exist == nil) then
            core.swap_node(pos, {name = "craftoplus:leaves_with_fruit_apple"});
        end
    end
});