local basement_schematic = core.get_modpath("exit_mt_generation").."/schematics/basement_structure.mts"

local placeholder_to_replace = {
    placeholder_01 = {"tables_chairs:planks_chair", "tables_chairs:planks_stool", "air"},
    placeholder_02 = {"exit_mt_blocks:old_bricks_02", "exit_mt_blocks:planks", "air"},
    placeholder_03 = {"exit_mt_blocks:box", "air"},
}

local sound_anomalies = {
    to_stop = nil,
    to_start = nil
}

local replace_or_nodes = function(start_pos, replaced_state, replace_nodes_amount, placeholder_nodes, level, anomaly_type)
    anomaly_type = anomaly_type or "normal"
    local node_pos = {0, {}, false}
    if not replaced_state then
        for k,positions in pairs(placeholder_nodes) do
            local name = k:gsub("exit_mt_blocks:", "")
            local node_replacements = placeholder_to_replace[name]
            for k,pos in pairs(positions) do
                local node_replacement_name = node_replacements[math.random(1, #node_replacements)]
                -- Id of a placeholder blocks at specific position, required to keep random blocks the same after each regeneration
                -- Possible todo, use custom schematic format
                local p_to_s = (start_pos - pos)
                p_to_s.x = math.abs(p_to_s.x)
                p_to_s.y = math.abs(p_to_s.y)
                p_to_s.z = math.abs(p_to_s.z)
                local id = tostring(p_to_s.x).."-"..tostring(p_to_s.y).."-"..tostring(p_to_s.z)

                local full_id = name.."-"..id
                
                node_pos[2][full_id] = {
                    name = name,
                    replacement_name = node_replacement_name,
                    pos = pos,
                    id = id,
                }
                local node = core.get_node(pos)
                core.set_node(pos, {name=node_replacement_name, param2=node.param2})
                node_pos[1] = node_pos[1] + 1
            end
        end
    else
        local nodes = {}
        local n = 0
        for k,positions in pairs(placeholder_nodes) do
            local name = k:gsub("exit_mt_blocks:", "")
            for _,pos in pairs(positions) do
                n = n + 1
                local p_to_s = (start_pos - pos)
                p_to_s.x = math.abs(p_to_s.x)
                p_to_s.y = math.abs(p_to_s.y)
                p_to_s.z = math.abs(p_to_s.z)
                local id = tostring(p_to_s.x).."-"..tostring(p_to_s.y).."-"..tostring(p_to_s.z)
                local full_id = name.."-"..id
                nodes[n] = {
                    name = name,
                    replacement_name = replaced_state[full_id].replacement_name,
                    pos = pos,
                    id = id,
                }
            end
        end

        local replace_nodes_amount = replace_nodes_amount or 2

        node_pos[1] = n

        local anomaly = false

        if anomaly_type == "node" then
            for i=replace_nodes_amount,1,-1 do
                local node = nodes[math.random(1, #nodes)]
                local node_replacements = placeholder_to_replace[node.name]
                local new_replacement_name = node_replacements[math.random(1, #node_replacements)]
                if new_replacement_name ~= node.replacement_name then
                    anomaly = true
                end
                node.replacement_name = new_replacement_name
            end
        elseif anomaly_type == "sound" then
            anomaly = true
            local node = nodes[math.random(1, #nodes)]
            sound_anomalies.to_start = {
                spec = {name="anomaly"},
                params = {
                    loop = true,
                    pos = node.pos,
                    max_hear_distance = 150,
                    pitch = 0.5 + math.random(),
                    gain = 0.5
                }
            }
        elseif anomaly_type == "schematic" then
            -- Not implemented yet
        end

        --core.chat_send_all(tostring(anomaly))

        for i=1,n do
            local node = nodes[i]
            local node_old = core.get_node(node.pos)
            core.set_node(node.pos, {name=node.replacement_name, param2=node_old.param2})
        end
       
        node_pos = replaced_state
        node_pos[3] = anomaly
        node_pos[2] = replaced_state
    end

    return node_pos
end

local get_trigger2_nodes = function(start_pos, trigger2_nodes)
    local nodes = {}
    local triggers = trigger2_nodes["exit_mt_blocks:trigger_02"]

    local t_to_s1 = (start_pos - triggers[1]):length()
    local t_to_s2 = (start_pos - triggers[2]):length()

    if t_to_s1 > t_to_s2 then
        nodes.enter = triggers[2]
        nodes.exit = triggers[1]
    else
        nodes.enter = triggers[1]
        nodes.exit = triggers[2]
    end

    core.set_node(triggers[1], {name="air"})
    core.set_node(triggers[2], {name="air"})
    
        
    return nodes
end

exit_mt_generation = {
    restart = function()
        if sound_anomalies.to_stop ~= nil then
            core.sound_stop(sound_anomalies.to_stop)
            sound_anomalies.to_stop = nil
        end
    end,
    enter_trigger = function()
        if sound_anomalies.to_stop ~= nil then
            core.sound_stop(sound_anomalies.to_stop)
            sound_anomalies.to_stop = nil
        end
        if sound_anomalies.to_start ~= nil then
            sound_anomalies.to_stop = core.sound_play(sound_anomalies.to_start.spec, sound_anomalies.to_start.params)
            sound_anomalies.to_start = nil
        end
    end,
    place_structure_first = function(replaced_state, anomaly_type)
        local start_pos = vector.new(0,0,0)
        local dir = vector.new(40,40,40)
        core.place_schematic(start_pos, basement_schematic, "0", true)
        

        local placeholder_nodes = core.find_nodes_in_area(start_pos-dir, start_pos+dir, 
            {
                "exit_mt_blocks:placeholder_01",
                "exit_mt_blocks:placeholder_02",
                "exit_mt_blocks:placeholder_03",
            },
            true
        )


        local node_pos = replace_or_nodes(start_pos, replaced_state, 2, placeholder_nodes, 0, anomaly_type)

        local trigger_nodes = core.find_nodes_in_area(start_pos-dir, start_pos+dir,
            {
                "exit_mt_blocks:trigger_01",
                "exit_mt_blocks:trigger_02",
                "exit_mt_blocks:placeholder_04"
            },
            true
        )

        
        for _,positions in pairs(trigger_nodes) do
            for k,pos in pairs(positions) do
                core.set_node(pos, {name="air"})
            end
        end

        local trigger2_nodes = get_trigger2_nodes(start_pos, trigger_nodes)

        return {
            game_nodes = node_pos,
            trigger1 = trigger_nodes["exit_mt_blocks:trigger_01"],
            trigger2 = trigger2_nodes,
            block = trigger_nodes["exit_mt_blocks:placeholder_04"]
        }
    end,
    place_structure_second = function(replaced_state, anomaly_type)
        local start_pos = vector.new(0,0,28)
        local dir = vector.new(40,40,40)
        core.place_schematic(start_pos, basement_schematic, "180", {}, true)
        

        local placeholder_nodes = core.find_nodes_in_area(start_pos-dir, start_pos+dir, 
            {
                "exit_mt_blocks:placeholder_01",
                "exit_mt_blocks:placeholder_02",
                "exit_mt_blocks:placeholder_03",
            },
            true
        )

        local node_pos = replace_or_nodes(vector.new(22,0,55), replaced_state, 2, placeholder_nodes, 1, anomaly_type)

        local trigger_nodes = core.find_nodes_in_area(start_pos-dir, start_pos+dir,
            {
                "exit_mt_blocks:trigger_01",
                "exit_mt_blocks:trigger_02",
                "exit_mt_blocks:placeholder_04"
            },
            true
        )

        
        for _,positions in pairs(trigger_nodes) do
            for k,pos in pairs(positions) do
                core.set_node(pos, {name="air"})
            end
        end

        local trigger2_nodes = get_trigger2_nodes(vector.new(22,0,55), trigger_nodes)

        return {
            game_nodes = node_pos,
            trigger1 = trigger_nodes["exit_mt_blocks:trigger_01"],
            trigger2 = trigger2_nodes,
            block = trigger_nodes["exit_mt_blocks:placeholder_04"]
        }
    end,
    place_structure = function()
        -- Not implemented yet, function to place structure and teleport players to after win

        -- local start_pos = vector.new(0,500,0)
        -- local dir = vector.new(30,30,30)
        -- core.place_schematic(start_pos, structure, "0", {}, true)

        -- local node = core.find_nodes_in_area(start_pos-dir, start_pos+dir,
        --     {
        --         "exit_mt_blocks:node",
        --     },
        --     true
        -- )

        -- return node["exit_mt_blocks:node"][1]
    end
}