-- LUALOCALS < ---------------------------------------------------------
local citadel, core, error, ipairs, next, pairs, vector
    = citadel, core, error, ipairs, next, pairs, vector
-- LUALOCALS > ---------------------------------------------------------

local api = ...

local modname = core.get_current_modname()
local modstore = core.get_mod_storage()
local storeget = arclib.util.structstore(modstore)

local alreadychecked
do
	local data, save = storeget("already_checked")
	alreadychecked = function()
		local state = api.manager.state
		local fresh = state and state.checked_locations
		if not fresh then return data end
		local checked = {}
		for _, i in ipairs(fresh) do
			checked[i] = true
		end
		return checked
	end
	api.manager.on("update", function()
			while next(data) do data[next(data)] = nil end
			for k, v in pairs(alreadychecked()) do data[k] = v end
			save()
		end)
end

local function setapitem(pos, inventory, clear)
	local checked = alreadychecked()
	for _, v in pairs(api.apdata.items) do
		if v.citadel_inventory == inventory
		or v.citadel_inventory .. "_node" == inventory then
			-- Location ID, not Item ID
			local id = v.id + 1000
			if checked[id] then
				if not clear then return end
				return core.remove_node(pos)
			end
			core.set_node(pos, {name = modname .. ":apitem"})
			return core.get_meta(pos):set_float("id", id)
		end
	end
	error("No item found for " .. inventory)
end

local function plantat(mytime, pos, plant, ptime, inventory)
	if ptime ~= mytime then return end
	return setapitem(pos, inventory)
end

-- Don't remove items from the world if the player already has
-- them; we want to do this only based on location checks.
function citadel.unique_item() end

do
	local oldfunc = citadel.change_time_period
	function citadel.change_time_period(time, ...)
		-- Remove plants from the world; they need to be obtained
		-- from the randomization pool.
		local data, save = storeget("init")
		if not data.plants then
			for _, v in ipairs(api.plantdata) do
				citadel.unrecord_plant(v.pos, v.plant)
			end
			data.plants = true
			save()
		end

		-- It seems like plant seeds are ALSO baked into the schematics,
		-- not just placed by the plant recording system. clear_objects
		-- gets called once in time period changes after schematic
		-- placement; monkey patch into it to also clear out duplicate
		-- plant seeds.
		local oldclear = core.clear_objects
		function core.clear_objects(...)
			local names = {}
			for _, v in ipairs(api.plantdata) do
				names[#names + 1] = v.item
				names[#names + 1] = v.item .. "_node"
			end
			for _, pos in pairs(minetest.find_nodes_in_area(
					vector.new(0, 0, 0), vector.new(45, 32, 43), names)) do
				core.remove_node(pos)
			end
			return oldclear(...)
		end

		-- Process stuff after change_time_period finishes
		local function helper(...)
			-- Restore original clear_objects before exiting.
			core.clear_objects = oldclear

			-- Replace plant seed original positions with apitems
			for _, v in ipairs(api.plantdata) do
				plantat(time, v.pos, v.plant, v.time, v.item)
			end

			-- Replace all gettable items that are NOT plants (which
			-- can only exist in the world if legit received)
			local plants = {}
			for _, pd in ipairs(api.plantdata) do
				plants[pd.item] = true
				plants[pd.item .. "_node"] = true
			end
			for _, pos in pairs(minetest.find_nodes_in_area(
					vector.new(0, 0, 0), vector.new(45, 32, 43), "group:breakable")) do
				local nodename = core.get_node(pos).name
				if not plants[nodename] then
					setapitem(pos, nodename, true)
				end
			end
			return ...
		end
		return helper(oldfunc(time, ...))
	end
end
