local S = core.get_translator("cow_core")

core.register_node("cow_core:stone", {
	description = S("Stone"),
	tiles = { "cow_core_stone.png" },
})

core.register_node("cow_core:grass_block", {
	description = S("Grass Block"),
	tiles = {
		{name="cow_core_grass.png", align_style="world", scale=4},
		{name="cow_core_grass.png", align_style="world", scale=4},
		"cow_core_grass_side.png",
	},
	groups = { bouncy = -100 }
})
core.register_node("cow_core:grass_dirt_block", {
	description = S("Dirt with Grass"),
	tiles = {
		"cow_core_grass_dark.png",
		"cow_core_dirt.png",
		"cow_core_grass_block_side.png",
		"cow_core_grass_block_side.png",
		"cow_core_grass_block_side.png",
		"cow_core_grass_block_side.png",
	},
	groups = { bouncy = -100 },
})

core.register_node("cow_core:grass_flower_block", {
	description = S("Grass Block with Flowers"),
	tiles = {
		"cow_core_grass_flowers.png",
		"cow_core_grass_flowers.png",
		"cow_core_grass_side.png",
	},
	groups = { bouncy = -100 }
})

core.register_node("cow_core:dirt", {
	description = S("Dirt"),
	tiles = { "cow_core_dirt.png" },
	groups = { bouncy = -100 },
})

-- Non-bouncy dirt
core.register_node("cow_core:hard_dirt", {
	description = S("Hard Dirt"),
	tiles = { "cow_core_dirt.png" },
})

core.register_node("cow_core:dirt_tilled", {
	description = S("Tilled Dirt"),
	tiles = { "cow_core_dirt_tilled.png", "cow_core_dirt.png" },
	groups = { bouncy = -100 },
})

core.register_node("cow_core:gravel_path", {
	description = S("Gravel Path"),
	paramtype = "light",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 7/16, 0.5 },
	},
	tiles = {
		"cow_core_gravel_path.png",
		"cow_core_dirt.png",
		"cow_core_gravel_path_side.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:dirt_path", {
	description = S("Dirt Path"),
	paramtype = "light",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 7/16, 0.5 },
	},
	tiles = {
		"cow_core_dirt_path.png",
		"cow_core_dirt.png",
		"cow_core_dirt_path_side.png",
	},
	groups = { bouncy = -100 },
})



core.register_node("cow_core:fence", {
	description = S("Fence"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "fencelike",
	tiles = {
		"cow_core_fence_top.png",
		"cow_core_fence_top.png",
		"cow_core_fence_side.png",
	},
	groups = { bouncy = -100 }
})

core.register_node("cow_core:water", {
	description = S("Water"),
	paramtype = "light",
	drawtype = "liquid",
	walkable = false,
	tiles = {
		"cow_core_water.png",
		"cow_core_water.png",
	},
	post_effect_color = { r = 48, g = 90, b = 205, a = 195 },
	use_texture_alpha = "blend",
})

core.register_node("cow_core:tree_willow", {
	description = S("Willow Tree Trunk"),
	tiles = {
		"cow_core_tree_willow_top.png",
		"cow_core_tree_willow_top.png",
		"cow_core_tree_willow.png",
	},
	paramtype2 = "facedir",
	groups = { bouncy = -100 },
})

core.register_node("cow_core:leaves_willow", {
	description = S("Willow Leaves"),
	paramtype = "light",
	drawtype = "allfaces_optional",
	tiles = {
		"cow_core_leaves_willow.png"
	},
	groups = { bouncy = -100 },
	use_texture_alpha = "clip",
})

core.register_node("cow_core:wood_red", {
	description = S("Red Wood"),
	tiles = {
		"cow_core_wood_red.png"
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:wood_brown", {
	description = S("Brown Wood"),
	tiles = { "cow_core_wood_brown.png" },
	groups = { bouncy = -100 },
})

core.register_node("cow_core:roof", {
	description = S("Roof Tiles Block"),
	tiles = {
		"cow_core_roof.png"
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:roof_angled", {
	description = S("Angled Roof Tiles"),
	paramtype = "light",
	paramtype2 = "4dir",
	drawtype = "nodebox",
	tiles = {
		"cow_core_roof.png"
	},
	node_box = {
		type = "fixed",
		fixed = {
			{ -0.5, -0.5, -0.5, 0.5, 0, 0.5 },
			{ -0.5, 0, 0, 0.5, 0.5, 0.5 },
		},
	},
	groups = { bouncy = -100 },
})



core.register_node("cow_core:hay_bale", {
	description = S("Hay Bale"),
	paramtype2 = "facedir",
	tiles = {
		"cow_core_hay_bale_top.png",
		"cow_core_hay_bale_top.png",
		"cow_core_hay_bale_side.png",
	},
	groups = { bouncy = -100 },
})

-- House nodes
core.register_node("cow_core:glass", {
	description = S("Glass"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "glasslike",
	tiles = {
		"cow_core_glass.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:door_wood_top", {
	description = S("Wooden Door (top segment)"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "nodebox",
	paramtype2 = "4dir",
	tiles = {
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_top.png^[transformFX",
		"cow_core_door_wood_top.png",
	},
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, -7/16 },
	},
	use_texture_alpha = "clip",
	groups = { bouncy = -100 },
})
core.register_node("cow_core:door_wood_bottom", {
	description = S("Wooden Door (bottom segment)"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "nodebox",
	paramtype2 = "4dir",
	tiles = {
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_bottom.png^[transformFX",
		"cow_core_door_wood_bottom.png",
	},
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, -7/16 },
	},
	use_texture_alpha = "clip",
	groups = { bouncy = -100 },
})
core.register_node("cow_core:door_carbon_steel_top", {
	description = S("Carbon Steel Door (top segment)"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "nodebox",
	paramtype2 = "4dir",
	tiles = {
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_top.png^[transformFX",
		"cow_core_door_carbon_steel_top.png",
	},
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, -7/16 },
	},
	use_texture_alpha = "clip",
	groups = { bouncy = -100 },
})
core.register_node("cow_core:door_carbon_steel_bottom", {
	description = S("Carbon Steel Door (bottom segment)"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "nodebox",
	paramtype2 = "4dir",
	tiles = {
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_bottom.png^[transformFX",
		"cow_core_door_carbon_steel_bottom.png",
	},
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, -7/16 },
	},
	use_texture_alpha = "clip",
	groups = { bouncy = -100 },
})


-- Industrial nodes

core.register_node("cow_core:lamp", {
	description = S("Lamp"),
	paramtype = "light",
	light_source = 10,
	tiles = {
		"cow_core_lamp.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:safety", {
	description = S("Conrete with Safety Stripes"),
	tiles = {
		"cow_core_safety.png",
		"cow_core_safety.png^[transformR90",
		"cow_core_safety.png^[transformFX",
		"cow_core_safety.png",
		"cow_core_safety.png^[transformFX",
		"cow_core_safety.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:steel_mesh", {
	description = S("Steel Mesh"),
	paramtype = "light",
	drawtype = "allfaces",
	tiles = {
		"cow_core_steel_mesh.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:concrete", {
	description = S("Concrete"),
	tiles = {
		"cow_core_concrete.png",
	},
	groups = { bouncy = -100 },
})
-- Non-bouncy concrete
core.register_node("cow_core:hard_concrete", {
	description = S("Hard Concrete"),
	tiles = {
		"cow_core_concrete.png",
	},
})

core.register_node("cow_core:concrete_white", {
	description = S("White Concrete"),
	tiles = {
		"cow_core_concrete_white.png",
	},
	groups = { bouncy = -100 },
})

core.register_node("cow_core:chainlink_fence", {
	description = S("Chainlink Fence"),
	tiles = {
		"cow_core_chainlink_top.png", 
		"cow_core_chainlink_top.png^[transformFY", 
		"cow_core_chainlink_sides.png^[transformFX", 
		"cow_core_chainlink_sides.png", 
		"cow_core_chainlink.png", 
	},
	drawtype = "nodebox",
	use_texture_alpha = "clip",
	paramtype2 = "4dir",
	paramtype = "light",
	sunlight_propagates = true,
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -1/16, 0.5, 0.5, 1/16 },
	},
	groups = { bouncy = -100 },
})

core.register_node("cow_core:carbon_steel", {
	description = S("Carbon Steel Block"),
	tiles = {
		"cow_core_carbon_steel.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:carbon_steel_electro_warning", {
	description = S("Carbon Steel Block with High Voltage Sign"),
	paramtype2 = "facedir",
	tiles = {
		"cow_core_carbon_steel.png",
		"cow_core_carbon_steel.png",
		"cow_core_carbon_steel.png",
		"cow_core_carbon_steel.png",
		"cow_core_carbon_steel.png",
		"cow_core_electro_warning.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:cable_box_double", {
	description = S("Cable Box (double-sided)"),
	paramtype2 = "facedir",
	tiles = {
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box.png",
		"cow_core_cable_box.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:cable_box_single", {
	description = S("Cable Box (single-sided)"),
	paramtype2 = "facedir",
	tiles = {
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box.png",
	},
	groups = { bouncy = -100 },
})

local cable_selbox
if core.is_creative_enabled("") then
	cable_selbox = {
		type = "fixed",
		fixed = { -4/16, -4/16, -0.5, 4/16, 4/16, 0.5 },
	}
end
core.register_node("cow_core:cable", {
	description = S("Cable"),
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	drawtype = "nodebox",
	tiles = {
		"cow_core_cable.png",
	},
	node_box = {
		type = "fixed",
		fixed = { -1/16, -1/16, -0.5, 1/16, 1/16, 0.5 },
	},
	selection_box = cable_selbox,
	groups = { bouncy = -100 },
})

-- Road blocks

core.register_node("cow_core:asphalt", {
	description = S("Asphalt"),
	tiles = { "cow_core_asphalt.png" },
	groups = { bouncy = -100 },
})
core.register_node("cow_core:asphalt_stripe_solid", {
	description = S("Asphalt with Solid Stripe"),
	paramtype2 = "4dir",
	tiles = { "cow_core_asphalt_stripe_solid.png", "cow_core_asphalt.png" },
	groups = { bouncy = -100 },
})
core.register_node("cow_core:asphalt_stripe_dashed", {
	description = S("Asphalt with Dashed Stripe"),
	paramtype2 = "4dir",
	tiles = { "cow_core_asphalt_stripe_dashed.png", "cow_core_asphalt.png" },
	groups = { bouncy = -100 },
})
core.register_node("cow_core:asphalt_stripe_side", {
	description = S("Asphalt with Side Stripe"),
	paramtype2 = "4dir",
	tiles = { "cow_core_asphalt_stripe_side.png", "cow_core_asphalt.png" },
	groups = { bouncy = -100 },
})
core.register_node("cow_core:asphalt_stripe_corner_outer", {
	description = S("Asphalt with Outer Corner Stripe"),
	paramtype2 = "4dir",
	tiles = { "cow_core_asphalt_stripe_corner_outer.png", "cow_core_asphalt.png" },
	groups = { bouncy = -100 },
})
core.register_node("cow_core:asphalt_stripe_corner_inner", {
	description = S("Asphalt with Inner Corner Stripe"),
	paramtype2 = "4dir",
	tiles = { "cow_core_asphalt_stripe_corner_inner.png", "cow_core_asphalt.png" },
	groups = { bouncy = -100 },
})

core.register_node("cow_core:sign_steel_post", {
	description = S("Steel Sign Post"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = { -1/16, -0.5, -1/16, 1/16, 0.5, 1/16 },
	},
	tiles = { "cow_core_sign_steel_post.png" },
	groups = { bouncy = -100 },
})
local road_signs = {
	{"arrow_left", S("Left Arrow") },
	{"arrow_right", S("Right Arrow") },
	{"arrow_up", S("Up Arrow") },
	{"warning", S("Warning") },
	{"wrong_way", S("Wrong Way") },
	{"30", S("Speed Limit 30 km/h") },
	{"60", S("Speed Limit 60 km/h") },
	{"90", S("Speed Limit 90 km/h") },
	{"cow", S("Cow") },
}
for r=1, #road_signs do
	local id = road_signs[r][1]
	local desc = road_signs[r][2]
	core.register_node("cow_core:sign_road_"..id, {
		description = S("Road Sign (@1)", desc),
		tiles = {
			"cow_core_sign_border.png", 
			"cow_core_sign_border.png", 
			"cow_core_sign_border.png", 
			"cow_core_sign_border.png", 
			"cow_core_sign_back.png",
			"cow_core_sign_"..id..".png",
		},
		drawtype = "nodebox",
		paramtype2 = "4dir",
		paramtype = "light",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -1/16, 0.5, 0.5, 1/16 },
		},
		groups = { bouncy = -100 },
	})
end
local traffic_lights = {
	{ "green", S("Green"), 30, "yellow" },
	{ "yellow", S("Yellow"), 3, "red" },
	{ "red", S("Red"), 30, "red_yellow" },
	{ "red_yellow", S("Red and Yellow"), 3, "green" },
	{ "off", S("Out of Order") },
}
for t=1, #traffic_lights do
	local id = traffic_lights[t][1]
	local desc = traffic_lights[t][2]
	local timer = traffic_lights[t][3]

	local next_id = traffic_lights[t][4]
	local on_timer, _on_level_init
	if timer then
		local timer_next
		for u=1, #traffic_lights do
			if traffic_lights[u][1] == next_id then
				timer_next = traffic_lights[u][3]
				break
			end
		end
		if not timer_next then
			core.log("error", "[cow_core] Could not get timer for next traffic light phase! (id="..id..")")
			timer_next = 3
		end
		_on_level_init = function(pos)
			local ntimer = core.get_node_timer(pos)
			ntimer:start(timer)
		end
		on_timer = function(pos)
			local node = core.get_node(pos)
			node.name = "cow_core:traffic_lights_"..next_id
			core.set_node(pos, node)
			local timer = core.get_node_timer(pos)
			timer:start(timer_next)
		end
	end
	core.register_node("cow_core:traffic_lights_"..id, {
		description = S("Traffic Lights (@1)", desc),
		tiles = {
			"cow_core_traffic_lights_sides.png", 
			"cow_core_traffic_lights_sides.png", 
			"cow_core_traffic_lights_sides.png", 
			"cow_core_traffic_lights_sides.png", 
			"cow_core_traffic_lights_sides.png", 
			"cow_core_traffic_lights_"..id..".png",
		},
		drawtype = "nodebox",
		paramtype2 = "4dir",
		paramtype = "light",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = { -3/16, -0.5, -3/16, 3/16, 0.5, 2/16 },
		},
		_cow_on_level_init = _on_level_init,
		on_timer = on_timer,
		groups = { needs_level_init = 1, bouncy = -100 },
	})
end

-- Plants

core.register_node("cow_core:flower_daisy", {
	description = S("Daisy"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "plantlike",
	paramtype2 = "meshoptions",
	walkable = false,
	tiles = {
		"cow_core_daisy.png"
	},
	waving = 1,
	selection_box = {
		type = "fixed",
		fixed = { -0.4, -0.5, -0.4, 0.4, -3/16, 0.4 },
	},
})

local clumps = {
	[1] = { -4/16 },
	[2] = { -1/16 },
}
for s=1, #clumps do
	local selection_ymax = clumps[s][1]
	core.register_node("cow_core:grass_clump_"..s, {
		description = S("Grass Clump (size @1)", s),
		walkable = false,
		paramtype = "light",
		sunlight_propagates = true,
		drawtype = "plantlike",
		paramtype2 = "meshoptions",
		tiles = {
			"cow_core_grass_clump_"..s..".png"
		},
		selection_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, selection_ymax, 0.5 },
		},
		waving = 1,
	})
end
core.register_node("cow_core:wheat", {
	description = S("Wheat"),
	walkable = false,
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "plantlike",
	paramtype2 = "meshoptions",
	place_param2 = 3,
	tiles = {
		"cow_core_wheat.png"
	},
	waving = 1,
})
core.register_node("cow_core:maize", {
	description = S("Maize"),
	walkable = false,
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "plantlike",
	paramtype2 = "meshoptions",
	place_param2 = 3,
	tiles = {
		"cow_core_maize.png"
	},
})
core.register_node("cow_core:maize_ripe", {
	description = S("Ripe Maize"),
	walkable = false,
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "plantlike",
	paramtype2 = "meshoptions",
	place_param2 = 3,
	tiles = {
		"cow_core_maize_ripe.png"
	},
})


core.register_node("cow_core:maize_top", {
	description = S("Maize Top"),
	walkable = false,
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "plantlike",
	paramtype2 = "meshoptions",
	place_param2 = 3,
	tiles = {
		"cow_core_maize_top.png"
	},
})

core.register_node("cow_core:bush", {
	description = S("Bush"),
	walkable = false,
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "plantlike",
	paramtype2 = "meshoptions",
	tiles = {
		"cow_core_bush.png"
	},
	waving = 1,
	visual_scale = 1.25,
})
core.register_node("cow_core:leaf_litter", {
	description = S("Leaf Litter"),
	walkable = false,
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, -15/32, 0.5 },
	},
	tiles = {
		"cow_core_leaf_litter.png",
		"cow_core_leaf_litter.png",
		"blank.png",
	},
	use_texture_alpha = "clip",
})


