--[[ init.lua
Copyright 2025 Pixelo789

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

SPDX-License-Identifier: AGPL-3.0-or-later
--]]


thinkingwitharrows_antigravity = {}
local modname = core.get_current_modname()
local S = core.get_translator(modname)


thinkingwitharrows_antigravity.GRAVITY_EARTH = 1
thinkingwitharrows_antigravity.GRAVITY_MOON = 1 / 6


function thinkingwitharrows_antigravity.set_gravity(player, gravity)
	local meta = player:get_meta()

	playerphysics.add_physics_factor(player, "gravity", "thinkingwitharrows_antigravity:gravity", gravity)
	XBows.GRAVITY = -10 * gravity
	meta:set_float("thinkingwitharrows_antigravity:gravity", gravity)
end


function thinkingwitharrows_antigravity.toggle_gravity(player)
	local meta = player:get_meta()
	local current_gravity = meta:get_float("thinkingwitharrows_antigravity:gravity")

	local factor = thinkingwitharrows_antigravity.GRAVITY_EARTH
	if current_gravity == 0 or current_gravity == thinkingwitharrows_antigravity.GRAVITY_EARTH then
		factor = thinkingwitharrows_antigravity.GRAVITY_MOON
	end
	playerphysics.add_physics_factor(player, "gravity", "thinkingwitharrows_antigravity:gravity", factor)
	XBows.GRAVITY = -10 * factor
	meta:set_float("thinkingwitharrows_antigravity:gravity", factor)
end


function thinkingwitharrows_antigravity.set_gravity_earthmoon(player, is_moon)
	if is_moon then
		thinkingwitharrows_antigravity.set_gravity(player, thinkingwitharrows_antigravity.GRAVITY_MOON)
	else
		thinkingwitharrows_antigravity.set_gravity(player, thinkingwitharrows_antigravity.GRAVITY_EARTH)
	end
end


core.register_on_joinplayer(function(player, last_login)
	local meta = player:get_meta()
	local current_gravity = meta:get_float("thinkingwitharrows_antigravity:gravity")
	if current_gravity == 0 then
		current_gravity = 1
		meta:set_float("thinkingwitharrows_antigravity:gravity", 1)
	end
	thinkingwitharrows_antigravity.set_gravity(player, current_gravity)
end)


local function toggle_block_interact(player)
	core.sound_play("thinkingwitharrows_woosh", {start_time = 0.05})
	thinkingwitharrows_antigravity.toggle_gravity(player)
end

local a = "thinkingwitharrows_antigravity_toggle_side.png"
local b = "thinkingwitharrows_antigravity_toggle_top.png"
register_node("thinkingwitharrows_antigravity:toggle", {
	description = S("Toggle gravity block"),
	tiles = {b, b, a},
	stack_max = 1000,
	groups = {oddly_breakable_by_hand = 2},
	on_rightclick = function(pos, node, player)
		toggle_block_interact(player)
	end,
	on_punch = function(pos, node, puncher, pointed_thing)
		local pt = pointed_thing or {}

		if pt.intersection_normal and pt.intersection_point and (puncher and puncher:is_player()) then
			toggle_block_interact(puncher)
		end
	end
})
